/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.book.BookLookupInfo;
import hellfirepvp.astralsorcery.common.auxiliary.book.BookLookupRegistry;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.FluidIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarUpgradeRecipe;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.util.IngredientHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;

public abstract class RenderPageRecipeTemplate
extends RenderablePage {
    protected Map<Rectangle, Tuple<ItemStack, Ingredient>> thisFrameInputStacks = new HashMap<Rectangle, Tuple<ItemStack, Ingredient>>();
    protected Tuple<Rectangle, ItemStack> thisFrameOuputStack = null;
    protected Rectangle thisFrameInfoStar = null;

    protected RenderPageRecipeTemplate(@Nullable ResearchNode node, int nodePage) {
        super(node, nodePage);
    }

    protected void clearFrameRectangles() {
        this.thisFrameInputStacks.clear();
        this.thisFrameOuputStack = null;
        this.thisFrameInfoStar = null;
    }

    public void renderRecipeGrid(float offsetX, float offsetY, float zLevel, AbstractRenderableTexture tex) {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        tex.bindTexture();
        RenderingGuiUtils.drawRect(offsetX + 25.0f, offsetY, zLevel, 129, 202);
        RenderSystem.disableBlend();
    }

    public void renderExpectedIngredientInput(float offsetX, float offsetY, float zLevel, double scale, long tickOffset, Ingredient ingredient) {
        ItemStack expected = IngredientHelper.getRandomVisibleStack(ingredient, ClientScheduler.getClientTick() + tickOffset);
        if (!expected.func_190926_b()) {
            BlockAtlasTexture.getInstance().bindTexture();
            this.renderItemStack(offsetX, offsetY, zLevel, scale, expected);
            this.thisFrameInputStacks.put(new Rectangle((int)offsetX, (int)offsetY, (int)(16.0 * scale), (int)(16.0 * scale)), (Tuple<ItemStack, Ingredient>)new Tuple((Object)expected, (Object)ingredient));
        }
    }

    public void renderExpectedIngredientInput(float offsetX, float offsetY, float zLevel, double scale, long tickOffset, List<ItemStack> displayOptions) {
        int mod = (int)((ClientScheduler.getClientTick() + tickOffset) / 20L % (long)displayOptions.size());
        ItemStack expected = displayOptions.get(MathHelper.func_76125_a((int)mod, (int)0, (int)(displayOptions.size() - 1)));
        if (!expected.func_190926_b()) {
            BlockAtlasTexture.getInstance().bindTexture();
            this.renderItemStack(offsetX, offsetY, zLevel, scale, expected);
            this.thisFrameInputStacks.put(new Rectangle((int)offsetX, (int)offsetY, (int)(16.0 * scale), (int)(16.0 * scale)), (Tuple<ItemStack, Ingredient>)new Tuple((Object)expected, null));
        }
    }

    public void renderExpectedRelayInputs(float offsetX, float offsetY, float zLevel, SimpleAltarRecipe altarRecipe) {
        float centerX = offsetX + 80.0f;
        float centerY = offsetY + 128.0f;
        float perc = (float)(ClientScheduler.getClientTick() % 3000L) / 3000.0f;
        List<WrappedIngredient> ingredients = altarRecipe.getRelayInputs();
        int amt = ingredients.size();
        for (int i = 0; i < ingredients.size(); ++i) {
            double part = (double)i / (double)amt * 2.0 * Math.PI;
            part = MathHelper.func_151237_a((double)part, (double)0.0, (double)(Math.PI * 2));
            double xAdd = Math.sin(part += Math.PI * 2 * (double)perc + Math.PI) * 75.0;
            double yAdd = Math.cos(part) * 75.0;
            this.renderExpectedIngredientInput((float)((double)centerX + xAdd), (float)((double)centerY + yAdd), zLevel, 1.0, (long)(i * 20), ingredients.get(i).getIngredient());
        }
    }

    public void renderExpectedItemStackOutput(float offsetX, float offsetY, float zLevel, double scale, ItemStack stack) {
        if (!stack.func_190926_b()) {
            BlockAtlasTexture.getInstance().bindTexture();
            this.renderItemStack(offsetX, offsetY, zLevel, scale, stack);
            this.thisFrameOuputStack = new Tuple((Object)new Rectangle((int)offsetX, (int)offsetY, (int)(16.0 * scale), (int)(16.0 * scale)), (Object)stack);
        }
    }

    protected void renderItemStack(float offsetX, float offsetY, float zLevel, double scale, ItemStack stack) {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)offsetX, (double)offsetY, (double)(zLevel + 60.0f));
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderingUtils.renderItemStack(Minecraft.func_71410_x().func_175599_af(), stack, 0, 0, null);
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)false);
    }

    public boolean handleRecipeNameCopyClick(double mouseX, double mouseZ, SimpleAltarRecipe recipe) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && Screen.hasControlDown() && ((Rectangle)this.thisFrameOuputStack.func_76341_a()).contains(mouseX, mouseZ)) {
            String recipeName = recipe.func_199560_c().toString();
            Minecraft.func_71410_x().field_195559_v.func_197960_a(recipeName);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.misc.ctrlcopy.copied", new Object[]{recipeName}));
            return true;
        }
        return false;
    }

    public boolean handleBookLookupClick(double mouseX, double mouseZ) {
        ItemStack stack;
        BookLookupInfo info;
        for (Rectangle r : this.thisFrameInputStacks.keySet()) {
            ItemStack stack2;
            BookLookupInfo info2;
            if (!r.contains(mouseX, mouseZ) || (info2 = BookLookupRegistry.findPage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, stack2 = (ItemStack)this.thisFrameInputStacks.get(r).func_76341_a())) == null || !info2.canSee(ResearchHelper.getProgress((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT)) || info2.getResearchNode().equals(this.getResearchNode())) continue;
            info2.openGui();
            return true;
        }
        if (this.thisFrameOuputStack != null && ((Rectangle)this.thisFrameOuputStack.func_76341_a()).contains(mouseX, mouseZ) && (info = BookLookupRegistry.findPage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, stack = (ItemStack)this.thisFrameOuputStack.func_76340_b())) != null && info.canSee(ResearchHelper.getProgress((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT)) && !info.getResearchNode().equals(this.getResearchNode())) {
            info.openGui();
            return true;
        }
        return false;
    }

    public void renderInfoStar(float offsetX, float offsetY, float zLevel, float pTicks) {
        MatrixStack renderStack = new MatrixStack();
        renderStack.func_227861_a_((double)(offsetX + 140.0f), (double)(offsetY + 20.0f), (double)zLevel);
        this.thisFrameInfoStar = RenderingDrawUtils.drawInfoStar(renderStack, IDrawRenderTypeBuffer.defaultBuffer(), 15.0f, pTicks);
        this.thisFrameInfoStar.translate((int)(offsetX + 140.0f), (int)(offsetY + 20.0f));
    }

    public void renderRequiredConstellation(float offsetX, float offsetY, float zLevel, @Nullable IConstellation constellation) {
        if (constellation != null) {
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(new Color(0xEEEEEE), constellation, Math.round(offsetX + 30.0f), Math.round(offsetY + 78.0f), zLevel, 125.0f, 125.0f, 2.0, () -> Float.valueOf(0.4f), true, false);
            RenderSystem.disableBlend();
        }
    }

    public void renderInfoStarTooltips(float offsetX, float offsetY, float zLevel, float mouseX, float mouseY, Consumer<List<ITextComponent>> tooltipProvider) {
        if (this.thisFrameInfoStar == null) {
            return;
        }
        LinkedList<ITextComponent> toolTip = new LinkedList<ITextComponent>();
        tooltipProvider.accept(toolTip);
        if (!toolTip.isEmpty() && this.thisFrameInfoStar.contains(mouseX, mouseY)) {
            RenderingDrawUtils.renderBlueTooltipComponents(offsetX, offsetY, zLevel += 600.0f, toolTip, RenderablePage.getFontRenderer(), false);
            zLevel -= 600.0f;
        }
    }

    public void renderHoverTooltips(float mouseX, float mouseY, float zLevel, ResourceLocation recipeName) {
        LinkedList<ITextComponent> toolTip = new LinkedList<ITextComponent>();
        this.addStackTooltip(mouseX, mouseY, recipeName, toolTip);
        if (!toolTip.isEmpty()) {
            RenderingDrawUtils.renderBlueTooltipComponents(mouseX, mouseY, zLevel += 800.0f, toolTip, RenderablePage.getFontRenderer(), true);
            zLevel -= 800.0f;
        }
    }

    protected void addAltarRecipeTooltip(SimpleAltarRecipe altarRecipe, List<ITextComponent> toolTip) {
        if (altarRecipe.getStarlightRequirement() > 0) {
            Enum highestPossible = null;
            ProgressionTier reached = ResearchHelper.getClientProgress().getTierReached();
            for (AltarType type : AltarType.values()) {
                if (highestPossible != null && type.isThisLEThan((AltarType)highestPossible) || !reached.isThisLaterOrEqual(type.getAssociatedTier().getRequiredProgress())) continue;
                highestPossible = type;
            }
            if (highestPossible != null) {
                long indexSel = ClientScheduler.getClientTick() / 30L % (long)(highestPossible.ordinal() + 1);
                AltarType typeSelected = AltarType.values()[(int)indexSel];
                ITextComponent itemName = typeSelected.getAltarItemRepresentation().func_200301_q();
                ITextComponent starlightRequired = this.getAltarStarlightAmountDescription(itemName, altarRecipe.getStarlightRequirement(), typeSelected.getStarlightCapacity());
                TranslationTextComponent starlightRequirementDescription = new TranslationTextComponent("astralsorcery.journal.recipe.altar.starlight.desc", new Object[0]);
                toolTip.add((ITextComponent)starlightRequirementDescription);
                toolTip.add(starlightRequired);
            }
        }
        if (altarRecipe instanceof AltarUpgradeRecipe) {
            toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.journal.recipe.altar.upgrade", new Object[0]));
        }
    }

    protected void addConstellationInfoTooltip(@Nullable IConstellation cst, List<ITextComponent> toolTip) {
        if (cst != null) {
            toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.journal.recipe.constellation", new Object[]{cst.getConstellationName()}));
        }
    }

    protected ITextComponent getAltarStarlightAmountDescription(ITextComponent altarName, float amountRequired, float maxAmount) {
        String base = "astralsorcery.journal.recipe.altar.starlight.";
        float perc = amountRequired / maxAmount;
        base = (double)perc <= 0.1 ? base + "lowest" : ((double)perc <= 0.25 ? base + "low" : ((double)perc <= 0.5 ? base + "avg" : ((double)perc <= 0.75 ? base + "more" : ((double)perc <= 0.9 ? base + "high" : (perc > 1.0f ? base + "toomuch" : base + "highest")))));
        return new TranslationTextComponent("astralsorcery.journal.recipe.altar.starlight.format", new Object[]{altarName, new TranslationTextComponent(base, new Object[0])});
    }

    protected ITextComponent getInfuserChanceDescription(float chance) {
        String base = "astralsorcery.journal.recipe.infusion.chance.";
        base = (double)chance <= 0.3 ? base + "low" : ((double)chance <= 0.7 ? base + "average" : (chance < 1.0f ? base + "high" : base + "always"));
        return new TranslationTextComponent(base, new Object[0]);
    }

    protected void addStackTooltip(float mouseX, float mouseY, ResourceLocation recipeName, List<ITextComponent> tooltip) {
        for (Rectangle rect : this.thisFrameInputStacks.keySet()) {
            if (!rect.contains(mouseX, mouseY)) continue;
            Tuple<ItemStack, Ingredient> inputInfo = this.thisFrameInputStacks.get(rect);
            this.addInputInformation((ItemStack)inputInfo.func_76341_a(), (Ingredient)inputInfo.func_76340_b(), tooltip);
            return;
        }
        if (((Rectangle)this.thisFrameOuputStack.func_76341_a()).contains(mouseX, mouseY)) {
            ItemStack stack = (ItemStack)this.thisFrameOuputStack.func_76340_b();
            this.addInputInformation(stack, null, tooltip);
            if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add(new TranslationTextComponent("astralsorcery.misc.recipename", new Object[]{recipeName.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE).func_150217_b(Boolean.valueOf(true))));
                tooltip.add(new TranslationTextComponent("astralsorcery.misc.ctrlcopy", new Object[]{recipeName.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE).func_150217_b(Boolean.valueOf(true))));
            }
        }
    }

    protected void addInputInformation(ItemStack stack, @Nullable Ingredient stackIngredient, List<ITextComponent> tooltip) {
        try {
            tooltip.addAll(stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        }
        catch (Exception exc) {
            tooltip.add(new TranslationTextComponent("astralsorcery.misc.tooltipError", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        BookLookupInfo info = BookLookupRegistry.findPage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, stack);
        if (info != null && info.canSee(ResearchHelper.getProgress((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT)) && !info.getResearchNode().equals(this.getResearchNode())) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(new TranslationTextComponent("astralsorcery.misc.craftInformation", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        if (stackIngredient != null && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            List<FluidStack> fluids;
            Tag<Item> itemTag = IngredientHelper.guessTag(stackIngredient);
            if (itemTag != null) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add(new TranslationTextComponent("astralsorcery.misc.input.tag", new Object[]{itemTag.func_199886_b().toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
            if (stackIngredient instanceof FluidIngredient && !(fluids = ((FluidIngredient)stackIngredient).getFluids()).isEmpty()) {
                ITextComponent cmp = null;
                for (FluidStack f : fluids) {
                    if (cmp == null) {
                        cmp = f.getFluid().getAttributes().getDisplayName(f);
                        continue;
                    }
                    cmp = new TranslationTextComponent("astralsorcery.misc.input.fluid.chain", new Object[]{cmp, f.getFluid().getAttributes().getDisplayName(f)}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
                }
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add(new TranslationTextComponent("astralsorcery.misc.input.fluid", new Object[]{cmp}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
        }
    }
}

