/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.client.StructureRenderer;
import hellfirepvp.observerlib.api.structure.Structure;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class RenderPageStructure
extends RenderablePage {
    private final StructureRenderer structureRenderer;
    private final Structure structure;
    private final Vector3 shift;
    private final List<Tuple<ItemStack, ITextComponent>> contentStacks;
    private final ITextComponent name;
    private Optional<Integer> drawSlice = Optional.empty();
    private Rectangle2D.Float switchView = null;
    private Rectangle2D.Float sliceUp = null;
    private Rectangle2D.Float sliceDown = null;
    private Rectangle2D.Float switchRequiredAir = null;
    private long totalRenderFrame = 0L;
    private boolean showAirBlocks = false;

    public RenderPageStructure(@Nullable ResearchNode node, int nodePage, Structure structure, @Nullable ITextComponent name, @Nonnull Vector3 shift) {
        super(node, nodePage);
        this.structure = structure;
        this.structureRenderer = new StructureRenderer(this.structure).setIsolateIndividualBlock(true);
        this.name = name;
        this.shift = shift;
        this.contentStacks = MapStream.ofKeys(structure.getAsStacks((IBlockReader)this.structureRenderer.getRenderWorld(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g), stack -> new StringTextComponent(stack.func_190916_E() + "x ").func_150257_a(stack.func_200301_q())).toTupleList();
    }

    @Override
    public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        ++this.totalRenderFrame;
        this.renderStructure(offsetX, offsetY, pTicks);
        float shift = this.renderSizeDescription(offsetX, offsetY + 5.0f, zLevel);
        if (this.name != null) {
            this.renderHeadline(offsetX + shift, offsetY + 5.0f, zLevel, this.name);
        }
        this.renderSliceButtons(offsetX, offsetY + 10.0f, zLevel, mouseX, mouseY);
    }

    private void renderSliceButtons(float offsetX, float offsetY, float zLevel, float mouseX, float mouseY) {
        TexturesAS.TEX_GUI_BOOK_STRUCTURE_ICONS.bindTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.switchView = null;
        this.sliceDown = null;
        this.sliceUp = null;
        this.switchRequiredAir = null;
        this.switchView = new Rectangle2D.Float(offsetX + 152.0f, offsetY + 10.0f, 16.0f, 16.0f);
        float u = this.drawSlice.isPresent() ? 0.5f : 0.0f;
        RenderingGuiUtils.drawTexturedRect(this.switchView.x, this.switchView.y, zLevel, this.switchView.width, this.switchView.height, u, 0.0f, 0.5f, 0.25f);
        if (this.drawSlice.isPresent()) {
            float v;
            int yLevel = this.drawSlice.get();
            int minSlice = this.getCurrentMinSlice();
            int maxSlice = this.getCurrentMaxSlice();
            if (yLevel < minSlice) {
                yLevel = maxSlice;
            }
            if (yLevel > maxSlice) {
                yLevel = maxSlice;
            }
            if (minSlice <= yLevel - 1) {
                this.sliceDown = new Rectangle2D.Float(offsetX + 160.0f, offsetY + 28.0f, 11.0f, 16.0f);
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.sliceDown.x + this.sliceDown.width / 2.0f), (float)(this.sliceDown.y + this.sliceDown.height / 2.0f), (float)zLevel);
                v = 0.5f;
                if (this.sliceDown.contains(mouseX, mouseY)) {
                    v = 0.25f;
                    RenderSystem.scalef((float)1.1f, (float)1.1f, (float)1.1f);
                }
                RenderSystem.translatef((float)(-this.sliceDown.width / 2.0f), (float)(-this.sliceDown.height / 2.0f), (float)0.0f);
                RenderingGuiUtils.drawTexturedRect(0.0f, 0.0f, 0.0f, this.sliceDown.width, this.sliceDown.height, 0.375f, v, 0.34375f, 0.25f);
                RenderSystem.popMatrix();
            }
            if (maxSlice >= yLevel + 1) {
                this.sliceUp = new Rectangle2D.Float(offsetX + 148.0f, offsetY + 28.0f, 11.0f, 16.0f);
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.sliceUp.x + this.sliceUp.width / 2.0f), (float)(this.sliceUp.y + this.sliceUp.height / 2.0f), (float)zLevel);
                v = 0.5f;
                if (this.sliceUp.contains(mouseX, mouseY)) {
                    v = 0.25f;
                    RenderSystem.scalef((float)1.1f, (float)1.1f, (float)1.1f);
                }
                RenderSystem.translatef((float)(-this.sliceUp.width / 2.0f), (float)(-this.sliceUp.height / 2.0f), (float)0.0f);
                RenderingGuiUtils.drawTexturedRect(0.0f, 0.0f, 0.0f, this.sliceUp.width, this.sliceUp.height, 0.0f, v, 0.34375f, 0.25f);
                RenderSystem.popMatrix();
            }
        }
        this.switchRequiredAir = new Rectangle2D.Float(offsetX + 134.0f, offsetY + 10.0f, 16.0f, 16.0f);
        RenderingGuiUtils.drawTexturedRect(this.switchRequiredAir.x, this.switchRequiredAir.y, zLevel, this.switchRequiredAir.width, this.switchRequiredAir.height, 0.0f, 0.75f, 0.5f, 0.25f);
        if (this.showAirBlocks) {
            BlockAtlasTexture.getInstance().bindTexture();
            RenderSystem.depthMask((boolean)false);
            RenderingUtils.draw(7, DefaultVertexFormats.field_176600_a, buf -> {
                MatrixStack renderStack = new MatrixStack();
                renderStack.func_227861_a_((double)(this.switchRequiredAir.x + 13.0f), (double)(this.switchRequiredAir.y + 11.0f), (double)(zLevel + 60.0f));
                renderStack.func_227862_a_(7.0f, -7.0f, 7.0f);
                renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
                renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(225.0f));
                RenderingUtils.renderSimpleBlockModel(Blocks.field_196824_gy.func_176223_P(), renderStack, (IVertexBuilder)buf);
            });
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.disableBlend();
    }

    private int getCurrentMinSlice() {
        int minSlice = this.structure.getMinimumOffset().func_177956_o();
        if (!this.showAirBlocks) {
            for (int yy = minSlice; yy <= this.structure.getMaximumOffset().func_177956_o(); ++yy) {
                boolean onlyAir = this.structure.getStructureSlice(yy).stream().allMatch(tpl -> ((MatchableState)tpl.func_76340_b()).equals(MatchableState.REQUIRES_AIR));
                if (onlyAir) continue;
                return yy;
            }
        }
        return minSlice;
    }

    private int getCurrentMaxSlice() {
        int maxSlice = this.structure.getMaximumOffset().func_177956_o();
        if (!this.showAirBlocks) {
            for (int yy = maxSlice; yy >= this.structure.getMinimumOffset().func_177956_o(); --yy) {
                boolean onlyAir = this.structure.getStructureSlice(yy).stream().allMatch(tpl -> ((MatchableState)tpl.func_76340_b()).equals(MatchableState.REQUIRES_AIR));
                if (onlyAir) continue;
                return yy;
            }
        }
        return maxSlice;
    }

    private void renderHeadline(float offsetX, float offsetY, float zLevel, ITextComponent title) {
        float scale = 1.3f;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.disableDepthTest();
        RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, zLevel, null, title.func_150254_d(), 0xDDDDDD, true);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
    }

    private float renderSizeDescription(float offsetX, float offsetY, float zLevel) {
        Vector3 size = new Vector3(this.structure.getMaximumOffset()).subtract(this.structure.getMinimumOffset()).add(1.0f, 1.0f, 1.0f);
        FontRenderer fr = RenderablePage.getFontRenderer();
        float scale = 1.3f;
        String desc = String.format("%s - %s - %s", size.getBlockX(), size.getBlockY(), size.getBlockZ());
        float length = (float)fr.func_78256_a(desc) * scale;
        RenderSystem.disableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)offsetX, (double)offsetY, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, zLevel, fr, desc, 0xDDDDDD, true);
        RenderSystem.popMatrix();
        this.drawSlice.ifPresent(yLevel -> {
            int min = this.getCurrentMinSlice();
            int max = this.getCurrentMaxSlice();
            int height = max - min;
            int level = yLevel - min;
            String sliceDescription = String.format("%s / %s", level + 1, height + 1);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)offsetX, (double)(offsetY + 14.0f), (double)0.0);
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            RenderingDrawUtils.renderStringAtPos(0.0f, 0.0f, zLevel, fr, sliceDescription, 0xDDDDDD, true);
            RenderSystem.popMatrix();
        });
        RenderSystem.enableDepthTest();
        return length + 8.0f;
    }

    private void renderStructure(float offsetX, float offsetY, float pTicks) {
        Point2D.Double renderOffset = this.renderOffset(offsetX + 8.0f, offsetY);
        this.structureRenderer.setRenderWithRequiredAir(this.showAirBlocks);
        this.structureRenderer.render3DSliceGUI(new MatrixStack(), renderOffset.x + this.shift.getX(), renderOffset.y + this.shift.getY(), pTicks, this.drawSlice);
        this.structureRenderer.setRenderWithRequiredAir(false);
    }

    private Point2D.Double renderOffset(float stdPageOffsetX, float stdPageOffsetY) {
        return new Point2D.Double((double)stdPageOffsetX + 78.75, (double)stdPageOffsetY + 132.0);
    }

    @Override
    public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
        String switchInfo;
        MatrixStack renderStack = new MatrixStack();
        renderStack.func_227861_a_((double)(offsetX + 160.0f), (double)(offsetY + 10.0f), (double)zLevel);
        Rectangle rect = RenderingDrawUtils.drawInfoStar(renderStack, IDrawRenderTypeBuffer.defaultBuffer(), 15.0f, pTicks);
        rect.translate((int)(offsetX + 160.0f), (int)(offsetY + 10.0f));
        if (rect.contains(mouseX, mouseY)) {
            RenderingDrawUtils.renderBlueTooltip(offsetX + 160.0f, offsetY + 10.0f, zLevel + 650.0f, this.contentStacks, RenderablePage.getFontRenderer(), false);
        }
        if (this.switchView != null && this.switchView.contains(mouseX, mouseY)) {
            switchInfo = LanguageMap.func_74808_a().func_74805_b("astralsorcery.journal.structure.switch_view");
            RenderingDrawUtils.renderBlueTooltipString(this.switchView.x + this.switchView.width / 2.0f, this.switchView.y + this.switchView.height / 2.0f, zLevel + 500.0f, Lists.newArrayList((Object[])new String[]{switchInfo}), RenderablePage.getFontRenderer(), false);
        }
        if (this.switchRequiredAir != null && this.switchRequiredAir.contains(mouseX, mouseY)) {
            switchInfo = LanguageMap.func_74808_a().func_74805_b("astralsorcery.journal.structure.required_air");
            RenderingDrawUtils.renderBlueTooltipString(this.switchRequiredAir.x + this.switchRequiredAir.width / 2.0f, this.switchRequiredAir.y + this.switchRequiredAir.height / 2.0f, zLevel + 500.0f, Lists.newArrayList((Object[])new String[]{switchInfo}), RenderablePage.getFontRenderer(), false);
        }
    }

    @Override
    public boolean propagateMouseDrag(double mouseDX, double mouseDZ) {
        this.structureRenderer.rotateFromMouseDrag((float)mouseDX, (float)mouseDZ);
        return true;
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        if (this.switchView != null && this.switchView.contains(mouseX, mouseZ)) {
            this.drawSlice = this.drawSlice.isPresent() ? Optional.empty() : Optional.of(this.getCurrentMinSlice());
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceUp != null && this.drawSlice.isPresent() && this.sliceUp.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() + 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceDown != null && this.drawSlice.isPresent() && this.sliceDown.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() - 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.switchRequiredAir != null && this.switchRequiredAir.contains(mouseX, mouseZ)) {
            boolean bl = this.showAirBlocks = !this.showAirBlocks;
            if (this.drawSlice.isPresent()) {
                int yLevel = this.drawSlice.get();
                int minSlice = this.getCurrentMinSlice();
                int maxSlice = this.getCurrentMaxSlice();
                if (yLevel < minSlice) {
                    yLevel = maxSlice;
                }
                if (yLevel > maxSlice) {
                    yLevel = maxSlice;
                }
                this.drawSlice = Optional.of(yLevel);
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

