/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.progression;

import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.journal.progression.JournalCluster;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class JournalProgressionClusterMapping {
    private static Map<ResearchProgression, JournalCluster> clusterMapping = new HashMap<ResearchProgression, JournalCluster>();

    public static void register(ResearchProgression prog, JournalCluster cluster) {
        clusterMapping.put(prog, cluster);
    }

    @Nonnull
    public static JournalCluster getClusterMapping(ResearchProgression progression) {
        JournalCluster cluster = clusterMapping.get((Object)progression);
        if (cluster == null) {
            throw new IllegalArgumentException("ResearchProgression " + progression.name() + " has no registered cluster!");
        }
        return cluster;
    }

    static {
        AbstractRenderableTexture tex = TexturesAS.TEX_GUI_CLUSTER_DISCOVERY;
        JournalProgressionClusterMapping.register(ResearchProgression.DISCOVERY, new JournalCluster(tex, tex, -2, -2, 0, 0));
        tex = TexturesAS.TEX_GUI_CLUSTER_BASICCRAFT;
        JournalProgressionClusterMapping.register(ResearchProgression.BASIC_CRAFT, new JournalCluster(tex, tex, 0, 1, 3, 3));
        tex = TexturesAS.TEX_GUI_CLUSTER_ATTUNEMENT;
        JournalProgressionClusterMapping.register(ResearchProgression.ATTUNEMENT, new JournalCluster(tex, tex, 2, -2, 4, 0));
        tex = TexturesAS.TEX_GUI_CLUSTER_CONSTELLATION;
        JournalProgressionClusterMapping.register(ResearchProgression.CONSTELLATION, new JournalCluster(tex, tex, 4, 0, 7, 2));
        tex = TexturesAS.TEX_GUI_CLUSTER_RADIANCE;
        JournalProgressionClusterMapping.register(ResearchProgression.RADIANCE, new JournalCluster(tex, tex, 5, -3, 8, -1));
        tex = TexturesAS.TEX_GUI_CLUSTER_BRILLIANCE;
        JournalProgressionClusterMapping.register(ResearchProgression.BRILLIANCE, new JournalCluster(tex, tex, 8, -1, 10, 1));
    }
}

