/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.ActiveCelestialsHandler;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class RenderingConstellationUtils {
    public static void renderConstellationSky(IConstellation c, MatrixStack renderStack, ActiveCelestialsHandler.RenderPosition renderPos, Supplier<Float> brightnessFn) {
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 renderOffset = renderPos.offset;
        Color rC = c.getTierRenderColor();
        int r = rC.getRed();
        int g = rC.getGreen();
        int b = rC.getBlue();
        Vector3 dirU = renderPos.incU.clone().subtract(renderOffset).divide(31.0);
        Vector3 dirV = renderPos.incV.clone().subtract(renderOffset).divide(31.0);
        double uLength = dirU.length();
        TexturesAS.TEX_STAR_CONNECTION.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (int j = 0; j < 2; ++j) {
                for (StarConnection con : c.getStarConnections()) {
                    Vector3 vecA = renderOffset.clone().add(dirU.clone().multiply(con.from.x + 1)).add(dirV.clone().multiply(con.from.y + 1));
                    Vector3 vecB = renderOffset.clone().add(dirU.clone().multiply(con.to.x + 1)).add(dirV.clone().multiply(con.to.y + 1));
                    Vector3 vecCV = vecB.subtract(vecA);
                    Vector3 oPane = dirV.clone().crossProduct(vecCV);
                    Vector3 vecAD = oPane.clone().crossProduct(vecCV).normalize().multiply(uLength);
                    Vector3 offset00 = vecA.subtract(vecAD.clone().multiply(j == 0 ? 1 : -1));
                    Vector3 vecU = vecAD.clone().multiply(j == 0 ? 2 : -2);
                    for (int i = 0; i < 4; ++i) {
                        Vector3 pos = offset00.clone().add(vecU.clone().multiply((i + 1 & 2) >> 1)).add(vecCV.clone().multiply((i + 2 & 2) >> 1));
                        buf.func_227888_a_(matr, (float)pos.getX(), (float)pos.getY(), (float)pos.getZ()).func_225586_a_(r, g, b, MathHelper.func_76125_a((int)((int)(((Float)brightnessFn.get()).floatValue() * 255.0f)), (int)0, (int)255)).func_225583_a_((float)((i + 2 & 2) >> 1), (float)((i + 3 & 2) >> 1)).func_181675_d();
                    }
                }
            }
        });
        TexturesAS.TEX_STAR_1.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (StarLocation star : c.getStars()) {
                int x = star.x;
                int y = star.y;
                Vector3 ofStar = renderOffset.clone().add(dirU.clone().multiply(x)).add(dirV.clone().multiply(y));
                for (int i = 0; i < 4; ++i) {
                    int u = (i + 1 & 2) >> 1;
                    int v = (i + 2 & 2) >> 1;
                    Vector3 pos = ofStar.clone().add(dirU.clone().multiply(u << 1)).add(dirV.clone().multiply(v << 1));
                    buf.func_227888_a_(matr, (float)pos.getX(), (float)pos.getY(), (float)pos.getZ()).func_225586_a_(r, g, b, MathHelper.func_76125_a((int)((int)(((Float)brightnessFn.get()).floatValue() * 255.0f)), (int)0, (int)255)).func_225583_a_((float)u, (float)v).func_181675_d();
                }
            }
        });
    }

    public static void renderConstellationIntoWorldFlat(IConstellation c, MatrixStack renderStack, IRenderTypeBuffer buffer, Vector3 offset, double scale, double line, float brightness) {
        RenderingConstellationUtils.renderConstellationIntoWorldFlat(c.getConstellationColor(), c, renderStack, buffer, offset, scale, line, brightness);
    }

    public static void renderConstellationIntoWorldFlat(Color color, IConstellation c, MatrixStack renderStack, IRenderTypeBuffer buffer, Vector3 offset, double scale, double line, float brightness) {
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 thisOffset = offset.clone();
        double starSize = 0.03125 * scale;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int connAlpha = (int)(brightness * 0.8f * 255.0f);
        int starAlpha = (int)(brightness * 255.0f);
        Vector3 drawOffset = new Vector3(-15.5 * starSize, 0.0, -15.5 * starSize);
        IVertexBuilder buf = buffer.getBuffer(RenderTypesAS.CONSTELLATION_WORLD_CONNECTION);
        for (StarConnection sc : c.getStarConnections()) {
            thisOffset.addY(0.001);
            Vector3 dirU = new Vector3(sc.to.x, 0, sc.to.y).subtract(sc.from.x, 0.0, sc.from.y).multiply(starSize);
            Vector3 dirV = dirU.clone().crossProduct(new Vector3(0, 1, 0)).setY(0).normalize().multiply(line * starSize);
            Vector3 starOffset = thisOffset.clone().addX((double)sc.from.x * starSize).addZ((double)sc.from.y * starSize);
            Vector3 offsetRender = starOffset.subtract(dirV.clone().divide(2.0));
            offsetRender.add(drawOffset);
            Vector3 pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(1));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, connAlpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(1));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, connAlpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(0));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, connAlpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(0));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, connAlpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        }
        Vector3 dirU = new Vector3(starSize * 2.0, 0.0, 0.0);
        Vector3 dirV = new Vector3(0.0, 0.0, starSize * 2.0);
        buf = buffer.getBuffer(RenderTypesAS.CONSTELLATION_WORLD_STAR);
        for (StarLocation sl : c.getStars()) {
            Vector3 offsetRender = thisOffset.clone().add((double)sl.x * starSize - starSize, 0.005, (double)sl.y * starSize - starSize);
            offsetRender.add(drawOffset);
            Vector3 pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(1));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, starAlpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(1));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, starAlpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(0));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, starAlpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(0));
            pos.drawPos(matr, buf).func_225586_a_(r, g, b, starAlpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        }
    }

    public static Map<StarLocation, Rectangle> renderConstellationIntoGUI(IConstellation c, float offsetX, float offsetY, float zLevel, float width, float height, double linebreadth, Supplier<Float> brightnessFn, boolean isKnown, boolean applyStarBrightness) {
        return RenderingConstellationUtils.renderConstellationIntoGUI(c.getTierRenderColor(), c, offsetX, offsetY, zLevel, width, height, linebreadth, brightnessFn, isKnown, applyStarBrightness);
    }

    public static Map<StarLocation, Rectangle> renderConstellationIntoGUI(Color col, IConstellation c, float offsetX, float offsetY, float zLevel, float width, float height, double linebreadth, Supplier<Float> brightnessFn, boolean isKnown, boolean applyStarBrightness) {
        double ulength = (double)width / 32.0;
        double vlength = (double)height / 32.0;
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        Vector3 offsetVec = new Vector3(offsetX, offsetY, zLevel);
        float starBrightness = 1.0f;
        if (applyStarBrightness && Minecraft.func_71410_x().field_71441_e != null) {
            starBrightness = Minecraft.func_71410_x().field_71441_e.func_228330_j_(1.0f);
            if (starBrightness <= 0.23f) {
                return new HashMap<StarLocation, Rectangle>();
            }
            starBrightness *= 2.0f;
        }
        float brightness = starBrightness;
        if (isKnown) {
            TexturesAS.TEX_STAR_CONNECTION.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                for (int j = 0; j < 2; ++j) {
                    for (StarConnection sc : c.getStarConnections()) {
                        int alpha = MathHelper.func_76125_a((int)((int)(((Float)brightnessFn.get()).floatValue() * brightness * 255.0f)), (int)0, (int)255);
                        Vector3 fromStar = new Vector3(offsetVec.getX() + (double)sc.from.x * ulength, offsetVec.getY() + (double)sc.from.y * vlength, offsetVec.getZ());
                        Vector3 toStar = new Vector3(offsetVec.getX() + (double)sc.to.x * ulength, offsetVec.getY() + (double)sc.to.y * vlength, offsetVec.getZ());
                        Vector3 dir = toStar.clone().subtract(fromStar);
                        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
                        Vector3 vec00 = fromStar.clone().add(degLot);
                        Vector3 vecV = degLot.clone().multiply(-2);
                        for (int i = 0; i < 4; ++i) {
                            int u = (i + 1 & 2) >> 1;
                            int v = (i + 2 & 2) >> 1;
                            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
                            buf.func_225582_a_(pos.getX(), pos.getY(), pos.getZ()).func_225586_a_(r, g, b, alpha).func_225583_a_((float)u, (float)v).func_181675_d();
                        }
                    }
                }
            });
        }
        HashMap<StarLocation, Rectangle> starRectangles = new HashMap<StarLocation, Rectangle>();
        TexturesAS.TEX_STAR_1.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (StarLocation sl : c.getStars()) {
                int alpha = MathHelper.func_76125_a((int)((int)(((Float)brightnessFn.get()).floatValue() * brightness * 255.0f)), (int)0, (int)255);
                int starX = sl.x;
                int starY = sl.y;
                Vector3 starVec = offsetVec.clone().addX((double)starX * ulength - ulength).addY((double)starY * vlength - vlength);
                Point upperLeft = new Point(starVec.getBlockX(), starVec.getBlockY());
                for (int i = 0; i < 4; ++i) {
                    int u = (i + 1 & 2) >> 1;
                    int v = (i + 2 & 2) >> 1;
                    Vector3 pos = starVec.clone().addX(ulength * (double)u * 2.0).addY(vlength * (double)v * 2.0);
                    buf.func_225582_a_(pos.getX(), pos.getY(), pos.getZ()).func_225586_a_(isKnown ? r : alpha, isKnown ? g : alpha, isKnown ? b : alpha, MathHelper.func_76125_a((int)((int)((float)alpha * 1.2f + 0.2f)), (int)0, (int)255)).func_225583_a_((float)u, (float)v).func_181675_d();
                }
                starRectangles.put(sl, new Rectangle(upperLeft.x, upperLeft.y, (int)(ulength * 2.0), (int)(vlength * 2.0)));
            }
        });
        return starRectangles;
    }

    public static float stdFlicker(long wtime, float partialTicks, int divisor) {
        return RenderingConstellationUtils.flickerSin(wtime, partialTicks, divisor, 2.0f, 0.5f);
    }

    public static float conCFlicker(long wtime, float partialTicks, int divisor) {
        return RenderingConstellationUtils.flickerSin(wtime, partialTicks, divisor, 4.0f, 0.375f);
    }

    private static float flickerSin(long wtime, float partialTicks, double divisor, float div, float move) {
        double rad = (double)((float)(wtime % (long)((Integer)GeneralConfig.CONFIG.dayLength.get() / 2)) + partialTicks) / divisor;
        float sin = MathHelper.func_76126_a((float)((float)rad));
        return sin / div + move;
    }
}

