/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common;

import hellfirepvp.astralsorcery.client.screen.ScreenConstellationPaper;
import hellfirepvp.astralsorcery.client.screen.ScreenHandTelescope;
import hellfirepvp.astralsorcery.client.screen.ScreenRefractionTable;
import hellfirepvp.astralsorcery.client.screen.ScreenTelescope;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.tile.TileRefractionTable;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum GuiType {
    CONSTELLATION_PAPER,
    TOME,
    REFRACTION_TABLE,
    TELESCOPE,
    HAND_TELESCOPE;


    public CompoundNBT serializeArguments(Object[] data) {
        try {
            CompoundNBT nbt = new CompoundNBT();
            switch (this) {
                case CONSTELLATION_PAPER: {
                    nbt.func_74778_a("cst", ((IConstellation)data[0]).getRegistryName().toString());
                    break;
                }
                case REFRACTION_TABLE: 
                case TELESCOPE: {
                    NBTHelper.writeBlockPosToNBT((BlockPos)data[0], nbt);
                    break;
                }
            }
            return nbt;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Invalid Arguments for GuiType: " + this.name(), exc);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Screen deserialize(CompoundNBT data) {
        ClientWorld clWorld = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity clPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clWorld == null || clPlayer == null) {
            return null;
        }
        try {
            switch (this) {
                case CONSTELLATION_PAPER: {
                    return new ScreenConstellationPaper((IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(new ResourceLocation(data.func_74779_i("cst"))));
                }
                case TOME: {
                    return ScreenJournalProgression.getOpenJournalInstance();
                }
                case REFRACTION_TABLE: {
                    BlockPos at = NBTHelper.readBlockPosFromNBT(data);
                    TileRefractionTable refractionTable = MiscUtils.getTileAt((IBlockReader)clWorld, at, TileRefractionTable.class, true);
                    if (refractionTable != null) {
                        return new ScreenRefractionTable(refractionTable);
                    }
                    return null;
                }
                case TELESCOPE: {
                    BlockPos at = NBTHelper.readBlockPosFromNBT(data);
                    TileTelescope telescope = MiscUtils.getTileAt((IBlockReader)clWorld, at, TileTelescope.class, true);
                    if (telescope != null) {
                        return new ScreenTelescope(telescope);
                    }
                    return null;
                }
                case HAND_TELESCOPE: {
                    return new ScreenHandTelescope();
                }
            }
            throw new IllegalArgumentException("Unknown GuiType: " + this.name());
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Invalid Arguments for GuiType: " + this.name(), exc);
        }
    }
}

