/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.tick.TickTokenMap;
import hellfirepvp.observerlib.common.util.tick.TickManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class BlockBreakHelper {
    private static final Map<ResourceLocation, TickTokenMap<BlockPos, BreakEntry>> breakMap = new HashMap<ResourceLocation, TickTokenMap<BlockPos, BreakEntry>>();

    public static BreakEntry addProgress(IWorld world, BlockPos pos, float expectedHardness, float percStrength) {
        TickTokenMap map = breakMap.computeIfAbsent(world.func_201675_m().func_186058_p().getRegistryName(), key -> {
            TickTokenMap tkMap = new TickTokenMap(TickEvent.Type.SERVER, new TickEvent.Type[0]);
            AstralSorcery.getProxy().getTickManager().register(tkMap);
            return tkMap;
        });
        BreakEntry breakProgress = (BreakEntry)map.get(pos);
        if (breakProgress == null) {
            breakProgress = new BreakEntry(Float.valueOf(expectedHardness), world, pos, world.func_180495_p(pos));
            map.put(pos, breakProgress);
        }
        BreakEntry breakEntry = breakProgress;
        breakEntry.breakProgress = breakEntry.breakProgress - percStrength;
        breakProgress.idleTimeout = 0;
        return breakProgress;
    }

    public static void clearServerCache() {
        TickManager mgr = AstralSorcery.getProxy().getTickManager();
        breakMap.values().forEach(arg_0 -> ((TickManager)mgr).unregister(arg_0));
        breakMap.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockBreakAnimation(PktPlayEffect pktPlayEffect) {
        BlockPos pos = ByteBufUtils.readPos(pktPlayEffect.getExtraData());
        int id = pktPlayEffect.getExtraData().readInt();
        BlockState state = Block.func_196257_b((int)id);
        RenderingUtils.playBlockBreakParticles(pos, state, state);
    }

    public static class BreakEntry
    implements TickTokenMap.TickMapToken<Float>,
    CEffectAbstractList.ListEntry {
        private float breakProgress;
        private final IWorld world;
        private BlockPos pos;
        private BlockState expected;
        private int idleTimeout;

        public BreakEntry(@Nonnull Float value, IWorld world, BlockPos at, BlockState expectedToBreak) {
            this.breakProgress = value.floatValue();
            this.world = world;
            this.pos = at;
            this.expected = expectedToBreak;
        }

        @Override
        public int getRemainingTimeout() {
            return this.breakProgress <= 0.0f || this.idleTimeout >= 20 ? 0 : 1;
        }

        @Override
        public void tick() {
            ++this.idleTimeout;
        }

        @Override
        public void onTimeout() {
            if (this.breakProgress > 0.0f) {
                return;
            }
            BlockState nowAt = this.world.func_180495_p(this.pos);
            if (this.world instanceof ServerWorld && BlockUtils.matchStateExact(this.expected, nowAt)) {
                BlockUtils.breakBlockWithoutPlayer((ServerWorld)this.world, this.pos, this.world.func_180495_p(this.pos), ItemStack.field_190927_a, true, true, true);
            }
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.breakProgress);
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(CompoundNBT nbt) {
            this.breakProgress = nbt.func_74760_g("breakProgress");
            this.pos = NBTHelper.readBlockPosFromNBT(nbt);
            this.expected = Block.func_196257_b((int)nbt.func_74762_e("expectedStateId"));
        }

        @Override
        public void writeToNBT(CompoundNBT nbt) {
            nbt.func_74776_a("breakProgress", this.breakProgress);
            NBTHelper.writeBlockPosToNBT(this.pos, nbt);
            nbt.func_74768_a("expectedStateId", Block.func_196246_j((BlockState)this.expected));
        }
    }
}

