/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class CropHelper {
    public static final String GROWABLE = "growable";
    public static final String GROWABLE_REED = "growable_reed";
    public static final String GROWABLE_CACTUS = "growable_cactus";
    public static final String GROWABLE_NETHERWART = "growable_netherwart";
    public static final String HARVESTABLE = "harvestable";
    public static Map<String, Function<BlockPos, GrowablePlant>> growableFactoryWrapper = new HashMap<String, Function<BlockPos, GrowablePlant>>(){
        {
            this.put(CropHelper.GROWABLE, GrowableWrapper::new);
            this.put(CropHelper.GROWABLE_REED, GrowableReedWrapper::new);
            this.put(CropHelper.GROWABLE_CACTUS, GrowableCactusWrapper::new);
            this.put(CropHelper.GROWABLE_NETHERWART, GrowableNetherwartWrapper::new);
            this.put(CropHelper.HARVESTABLE, HarvestableWrapper::new);
        }
    };

    @Nullable
    public static GrowablePlant fromNBT(CompoundNBT nbt, BlockPos pos) {
        return growableFactoryWrapper.getOrDefault(nbt.func_74779_i("identifier"), p -> null).apply(pos);
    }

    @Nullable
    public static GrowablePlant wrapPlant(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (state.func_177230_c() instanceof IGrowable) {
            if (b instanceof GrassBlock) {
                return null;
            }
            if (b instanceof TallGrassBlock) {
                return null;
            }
            if (b instanceof DoublePlantBlock) {
                return null;
            }
            return new GrowableWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_196608_cF) && CropHelper.isReedBase(world, pos)) {
            return new GrowableReedWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_150434_aF) && CropHelper.isCactusBase(world, pos)) {
            return new GrowableCactusWrapper(pos);
        }
        if (state.func_177230_c().equals(Blocks.field_150388_bm)) {
            return new GrowableNetherwartWrapper(pos);
        }
        return null;
    }

    @Nullable
    public static HarvestablePlant wrapHarvestablePlant(IWorld world, BlockPos pos) {
        GrowablePlant growable = CropHelper.wrapPlant(world, pos);
        if (growable == null) {
            return null;
        }
        BlockState state = world.func_180495_p(growable.getPos());
        if (state.func_177230_c().equals(Blocks.field_196608_cF) && growable instanceof GrowableReedWrapper) {
            return (GrowableReedWrapper)growable;
        }
        if (state.func_177230_c().equals(Blocks.field_150434_aF) && growable instanceof GrowableCactusWrapper) {
            return (GrowableCactusWrapper)growable;
        }
        if (state.func_177230_c().equals(Blocks.field_150388_bm) && growable instanceof GrowableNetherwartWrapper) {
            return (GrowableNetherwartWrapper)growable;
        }
        if (state.func_177230_c() instanceof IPlantable) {
            return new HarvestableWrapper(pos);
        }
        return null;
    }

    private static boolean isReedBase(IWorld world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_196608_cF);
    }

    private static boolean isCactusBase(IWorld world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150434_aF);
    }

    public static class GrowableWrapper
    implements GrowablePlant {
        private final BlockPos pos;

        public GrowableWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public String getIdentifier() {
            return CropHelper.GROWABLE;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public boolean isValid(IWorld world) {
            return CropHelper.wrapPlant(world, this.pos) instanceof GrowableWrapper;
        }

        @Override
        public boolean canGrow(IWorld world) {
            BlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c() instanceof IGrowable && (((IGrowable)at.func_177230_c()).func_176473_a((IBlockReader)world, this.pos, at, false) || at.func_177230_c() instanceof StemBlock && !this.stemHasCrop(world));
        }

        private boolean stemHasCrop(IWorld world) {
            for (Direction enumfacing : Direction.Plane.HORIZONTAL) {
                Block offset = world.func_180495_p(this.pos.func_177972_a(enumfacing)).func_177230_c();
                if (!offset.equals(Blocks.field_150440_ba) && !offset.equals(Blocks.field_150423_aK)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryGrow(IWorld world, Random rand) {
            BlockState at = world.func_180495_p(this.pos);
            if (at.func_177230_c() instanceof IGrowable && world instanceof ServerWorld) {
                if (((IGrowable)at.func_177230_c()).func_176473_a((IBlockReader)world, this.pos, at, false)) {
                    if (!((IGrowable)at.func_177230_c()).func_180670_a((World)world, rand, this.pos, at) && rand.nextInt(20) != 0) {
                        return true;
                    }
                    ((IGrowable)at.func_177230_c()).func_225535_a_((ServerWorld)world, rand, this.pos, at);
                    return true;
                }
                if (at.func_177230_c() instanceof StemBlock) {
                    for (int i = 0; i < 10; ++i) {
                        at.func_227033_a_((ServerWorld)world, this.pos, rand);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public static class GrowableReedWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableReedWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(IWorld world) {
            return world.func_180495_p(this.pos.func_177984_a()).func_177230_c().equals(Blocks.field_196608_cF);
        }

        @Override
        public NonNullList<ItemStack> harvestDropsAndReplant(ServerWorld world, Random rand, int harvestFortune) {
            NonNullList drops = NonNullList.func_191196_a();
            for (int i = 2; i > 0; --i) {
                BlockPos bp = this.pos.func_177981_b(i);
                BlockState at = world.func_180495_p(bp);
                if (!at.func_177230_c().equals(Blocks.field_196608_cF)) continue;
                drops.addAll(BlockUtils.getDrops(world, this.pos, harvestFortune, rand));
                world.func_217377_a(bp, false);
            }
            return drops;
        }

        @Override
        public boolean isValid(IWorld world) {
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_196608_cF);
        }

        @Override
        public boolean canGrow(IWorld world) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                BlockState state = world.func_180495_p(cache = cache.func_177984_a());
                if (state.isAir((IBlockReader)world, cache)) {
                    return true;
                }
                if (!(state.func_177230_c() instanceof SugarCaneBlock)) break;
            }
            return false;
        }

        @Override
        public boolean tryGrow(IWorld world, Random rand) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                BlockState state = world.func_180495_p(cache = cache.func_177984_a());
                if (state.isAir((IBlockReader)world, cache)) {
                    if (rand.nextBoolean()) {
                        return world.func_180501_a(cache, Blocks.field_196608_cF.func_176223_P(), 3);
                    }
                    return false;
                }
                if (!(state.func_177230_c() instanceof SugarCaneBlock)) break;
            }
            return false;
        }

        @Override
        public String getIdentifier() {
            return CropHelper.GROWABLE_REED;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }
    }

    public static class GrowableCactusWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableCactusWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(IWorld world) {
            return world.func_180495_p(this.pos.func_177984_a()).func_177230_c().equals(Blocks.field_150434_aF);
        }

        @Override
        public boolean isValid(IWorld world) {
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_150434_aF);
        }

        @Override
        public NonNullList<ItemStack> harvestDropsAndReplant(ServerWorld world, Random rand, int harvestFortune) {
            NonNullList drops = NonNullList.func_191196_a();
            for (int i = 2; i > 0; --i) {
                BlockPos bp = this.pos.func_177981_b(i);
                BlockState at = world.func_180495_p(bp);
                if (!at.func_177230_c().equals(Blocks.field_150434_aF)) continue;
                BlockUtils.breakBlockWithoutPlayer(world, bp);
            }
            return drops;
        }

        @Override
        public boolean canGrow(IWorld world) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                BlockState state = world.func_180495_p(cache = cache.func_177984_a());
                if (state.isAir((IBlockReader)world, cache)) {
                    return true;
                }
                if (!(state.func_177230_c() instanceof CactusBlock)) break;
            }
            return false;
        }

        @Override
        public boolean tryGrow(IWorld world, Random rand) {
            BlockPos cache = this.pos;
            for (int i = 1; i < 3; ++i) {
                BlockState state = world.func_180495_p(cache = cache.func_177984_a());
                if (state.isAir((IBlockReader)world, cache)) {
                    if (rand.nextBoolean()) {
                        return world.func_180501_a(cache, Blocks.field_150434_aF.func_176223_P(), 3);
                    }
                    return false;
                }
                if (!(state.func_177230_c() instanceof CactusBlock)) break;
            }
            return false;
        }

        @Override
        public String getIdentifier() {
            return CropHelper.GROWABLE_CACTUS;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }
    }

    public static class GrowableNetherwartWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public GrowableNetherwartWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean isValid(IWorld world) {
            return world.func_180495_p(this.pos).func_177230_c().equals(Blocks.field_150388_bm);
        }

        @Override
        public boolean canGrow(IWorld world) {
            BlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c().equals(Blocks.field_150388_bm) && (Integer)at.func_177229_b((IProperty)NetherWartBlock.field_176486_a) < 3;
        }

        @Override
        public boolean tryGrow(IWorld world, Random rand) {
            if (rand.nextBoolean()) {
                BlockState current = world.func_180495_p(this.pos);
                return world.func_180501_a(this.pos, (BlockState)current.func_206870_a((IProperty)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(Math.min(3, (Integer)current.func_177229_b((IProperty)NetherWartBlock.field_176486_a) + 1))), 3);
            }
            return false;
        }

        @Override
        public boolean canHarvest(IWorld world) {
            BlockState current = world.func_180495_p(this.pos);
            return current.func_177230_c().equals(Blocks.field_150388_bm) && (Integer)current.func_177229_b((IProperty)NetherWartBlock.field_176486_a) >= 3;
        }

        @Override
        public NonNullList<ItemStack> harvestDropsAndReplant(ServerWorld world, Random rand, int harvestFortune) {
            NonNullList stacks = NonNullList.func_191196_a();
            stacks.addAll(BlockUtils.getDrops(world, this.pos, harvestFortune, rand));
            world.func_180501_a(this.pos, (BlockState)Blocks.field_150388_bm.func_176223_P().func_206870_a((IProperty)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(1)), 3);
            return stacks;
        }

        @Override
        public String getIdentifier() {
            return CropHelper.GROWABLE_NETHERWART;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }
    }

    public static class HarvestableWrapper
    implements HarvestablePlant {
        private final BlockPos pos;

        public HarvestableWrapper(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public boolean canHarvest(IWorld world) {
            BlockState at = world.func_180495_p(this.pos);
            if (!(at.func_177230_c() instanceof IGrowable)) {
                return false;
            }
            return !((IGrowable)at.func_177230_c()).func_176473_a((IBlockReader)world, this.pos, at, false);
        }

        @Override
        public NonNullList<ItemStack> harvestDropsAndReplant(ServerWorld world, Random rand, int harvestFortune) {
            NonNullList drops = NonNullList.func_191196_a();
            if (this.canHarvest((IWorld)world)) {
                BlockPos pos = this.getPos();
                BlockState at = world.func_180495_p(this.getPos());
                if (at.func_177230_c() instanceof IPlantable) {
                    drops.addAll(BlockUtils.getDrops(world, pos, harvestFortune, rand));
                    world.func_217377_a(pos, false);
                    world.func_175656_a(pos, ((IPlantable)at.func_177230_c()).getPlant((IBlockReader)world, pos));
                }
            }
            return drops;
        }

        @Override
        public String getIdentifier() {
            return CropHelper.HARVESTABLE;
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public boolean isValid(IWorld world) {
            return CropHelper.wrapHarvestablePlant(world, this.getPos()) instanceof HarvestableWrapper;
        }

        @Override
        public boolean canGrow(IWorld world) {
            BlockState at = world.func_180495_p(this.pos);
            return at.func_177230_c() instanceof IGrowable && ((IGrowable)at.func_177230_c()).func_176473_a((IBlockReader)world, this.pos, at, false);
        }

        @Override
        public boolean tryGrow(IWorld world, Random rand) {
            BlockState at = world.func_180495_p(this.pos);
            if (at.func_177230_c() instanceof IGrowable && world instanceof ServerWorld && ((IGrowable)at.func_177230_c()).func_176473_a((IBlockReader)world, this.pos, at, false)) {
                ((IGrowable)at.func_177230_c()).func_225535_a_((ServerWorld)world, rand, this.pos, at);
                return true;
            }
            return false;
        }
    }

    public static interface HarvestablePlant
    extends GrowablePlant {
        public boolean canHarvest(IWorld var1);

        public NonNullList<ItemStack> harvestDropsAndReplant(ServerWorld var1, Random var2, int var3);
    }

    public static interface GrowablePlant
    extends CEffectAbstractList.ListEntry {
        public String getIdentifier();

        public boolean isValid(IWorld var1);

        public boolean canGrow(IWorld var1);

        public boolean tryGrow(IWorld var1, Random var2);

        @Override
        default public void readFromNBT(CompoundNBT nbt) {
        }

        @Override
        default public void writeToNBT(CompoundNBT nbt) {
            nbt.func_74778_a("identifier", this.getIdentifier());
        }
    }
}

