/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.gateway;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayFilter;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktUpdateGateways;
import hellfirepvp.astralsorcery.common.util.SidedReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class CelestialGatewayHandler {
    public static final CelestialGatewayHandler INSTANCE = new CelestialGatewayHandler();
    private CelestialGatewayFilter filter = null;
    private boolean startUp = false;
    private final SidedReference<Map<ResourceLocation, Collection<GatewayCache.GatewayNode>>> cache = new SidedReference();

    private CelestialGatewayHandler() {
    }

    private CelestialGatewayFilter getFilter() {
        if (this.filter == null) {
            this.filter = new CelestialGatewayFilter();
        }
        return this.filter;
    }

    public void addPosition(IWorld world, GatewayCache.GatewayNode node) {
        Optional<Collection> worldData;
        if (world.func_201670_d()) {
            return;
        }
        ResourceLocation dimKey = world.func_201675_m().func_186058_p().getRegistryName();
        if (!this.cache.getData(LogicalSide.SERVER).map(map -> (Collection)map.get(dimKey)).isPresent()) {
            this.forceLoad(world.func_201675_m().func_186058_p());
        }
        if (!(worldData = this.cache.getData(LogicalSide.SERVER).map(map -> (Collection)map.get(dimKey))).isPresent()) {
            AstralSorcery.log.info("Couldn't add gateway at " + node.getPos() + " - loading the world failed.");
            return;
        }
        Collection nodes = worldData.get();
        this.getFilter().addDim(dimKey);
        if (!nodes.contains(node)) {
            nodes.add(node);
            this.syncToAll();
        }
    }

    public void removePosition(IWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        ResourceLocation dimKey = world.func_201675_m().func_186058_p().getRegistryName();
        Optional<Collection> worldData = this.cache.getData(LogicalSide.SERVER).map(map -> (Collection)map.get(dimKey));
        if (!worldData.isPresent()) {
            return;
        }
        Collection nodes = worldData.get();
        if (nodes.removeIf(node -> node.getPos().equals((Object)pos))) {
            if (nodes.isEmpty()) {
                this.getFilter().removeDim(dimKey);
            }
            this.syncToAll();
        }
    }

    private void forceLoad(DimensionType type) {
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        srv.func_71218_a(type);
    }

    public void onServerStart() {
        this.startUp = true;
        CelestialGatewayFilter filter = this.getFilter();
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        DimensionManager.getRegistry().func_201756_e().forEach(type -> {
            if (!filter.hasGateways(type.getRegistryName())) {
                return;
            }
            this.loadIntoCache((IWorld)server.func_71218_a(type));
        });
        this.startUp = false;
    }

    public void onServerStop() {
        this.cache.setData(LogicalSide.SERVER, null);
    }

    public void onWorldInit(WorldEvent.Load event) {
        if (this.startUp) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        this.loadIntoCache(world);
        this.syncToAll();
    }

    public void syncToAll() {
        PktUpdateGateways pkt = new PktUpdateGateways(this.getGatewayCache(LogicalSide.SERVER));
        PacketChannel.CHANNEL.sendToAll(pkt);
    }

    public Collection<GatewayCache.GatewayNode> getGatewaysForWorld(IWorld world, LogicalSide side) {
        return this.cache.getData(side).map(data -> data.getOrDefault(world.func_201675_m().func_186058_p().getRegistryName(), Collections.emptyList())).orElse(Collections.emptyList());
    }

    public Map<ResourceLocation, Collection<GatewayCache.GatewayNode>> getGatewayCache(LogicalSide side) {
        return this.cache.getData(side).orElse(Collections.emptyMap());
    }

    @Nullable
    public GatewayCache.GatewayNode getGatewayNode(IWorld world, LogicalSide side, BlockPos pos) {
        return ((Collection)this.cache.getData(side).map(data -> (Collection)data.get(world.func_201675_m().func_186058_p().getRegistryName())).orElse(Collections.emptyList())).stream().filter(node -> node.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientCache(@Nullable Map<ResourceLocation, Collection<GatewayCache.GatewayNode>> positions) {
        this.cache.setData(LogicalSide.CLIENT, positions);
    }

    private void loadIntoCache(IWorld world) {
        GatewayCache cache = (GatewayCache)DataAS.DOMAIN_AS.getData(world, DataAS.KEY_GATEWAY_CACHE);
        Map gatewayCache = this.cache.getData(LogicalSide.SERVER).orElse(new HashMap());
        gatewayCache.put(world.func_201675_m().func_186058_p().getRegistryName(), new HashSet<GatewayCache.GatewayNode>(cache.getGatewayPositions()));
        this.cache.setData(LogicalSide.SERVER, gatewayCache);
    }
}

