/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.types;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXPositionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class TypeStarHalo
extends PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;

    public TypeStarHalo(UUID effectUUID, @Nullable FlareColor flareColor, UUID playerUUID) {
        super(effectUUID, flareColor);
        this.playerUUID = playerUUID;
    }

    @Override
    public void attachTickListeners(Consumer<ITickHandler> registrar) {
        super.attachTickListeners(registrar);
        registrar.accept(this);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (side.isClient() && this.shouldDoEffect(player)) {
            this.spawnHaloParticles(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnHaloParticles(final PlayerEntity player) {
        Vector3 headPos = Vector3.atEntityCorner((Entity)player).addY(player.func_213307_e(player.func_213283_Z()));
        for (int i = 0; i < 3; ++i) {
            final Vector3 offset = MiscUtils.getRandomCirclePosition(new Vector3(), Vector3.RotAxis.Y_AXIS, 0.3f);
            float scale = 0.16f + rand.nextFloat() * 0.12f;
            int age = 20 + rand.nextInt(10);
            MiscUtils.applyRandomOffset(offset, rand, 0.02f);
            FXFacingParticle particle = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(headPos.clone().addY(0.4f).add(offset))).setAlphaMultiplier(0.8f)).alpha(((VFXAlphaFunction<EntityVisualFX>)(fx, alphaIn, pTicks) -> {
                if (this.shouldDoEffect(player) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player.field_70125_A < -30.0f) {
                    return MathHelper.func_76131_a((float)(1.0f - (Math.abs(player.field_70125_A) - 30.0f) / 15.0f), (float)0.0f, (float)1.0f) * alphaIn;
                }
                return alphaIn;
            }).andThen(VFXAlphaFunction.PYRAMID))).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_TYPE_WEAK))).setScaleMultiplier(scale)).setMaxAge(age);
            if (rand.nextInt(3) == 0) {
                particle.color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_VICIO));
            }
            EntityVisualFX starParticle = null;
            if (rand.nextInt(5) == 0) {
                starParticle = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(headPos.clone().addY(0.4f).add(offset))).setAlphaMultiplier(0.8f)).color(VFXColorFunction.WHITE)).alpha(((VFXAlphaFunction<EntityVisualFX>)(fx, alphaIn, pTicks) -> {
                    if (this.shouldDoEffect(player) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player.field_70125_A < -30.0f) {
                        return MathHelper.func_76131_a((float)(1.0f - (Math.abs(player.field_70125_A) - 30.0f) / 15.0f), (float)0.0f, (float)1.0f) * alphaIn;
                    }
                    return alphaIn;
                }).andThen(VFXAlphaFunction.PYRAMID))).setScaleMultiplier(scale * 0.6f)).setMaxAge(age);
            }
            if (rand.nextInt(4) == 0) continue;
            particle.position(new VFXPositionController<EntityVisualFX>(){

                @Override
                @Nonnull
                public Vector3 updatePosition(@Nonnull EntityVisualFX fx, @Nonnull Vector3 position, @Nonnull Vector3 motionToBeMoved) {
                    if (TypeStarHalo.this.shouldDoEffect(player)) {
                        Vector3 diff = new Vector3(player.field_70169_q - player.func_226277_ct_(), player.field_70167_r - player.func_226278_cu_(), player.field_70166_s - player.func_226281_cx_());
                        diff.divide(4.0);
                        return Vector3.atEntityCorner((Entity)player).add(diff).addY(player.func_213307_e(player.func_213283_Z())).addY(0.4f).add(offset);
                    }
                    return new Vector3();
                }
            });
            if (starParticle == null) continue;
            starParticle.position(new VFXPositionController<EntityVisualFX>(){

                @Override
                @Nonnull
                public Vector3 updatePosition(@Nonnull EntityVisualFX fx, @Nonnull Vector3 position, @Nonnull Vector3 motionToBeMoved) {
                    if (TypeStarHalo.this.shouldDoEffect(player)) {
                        Vector3 diff = new Vector3(player.field_70169_q - player.func_226277_ct_(), player.field_70167_r - player.func_226278_cu_(), player.field_70166_s - player.func_226281_cx_());
                        diff.divide(4.0);
                        return Vector3.atEntityCorner((Entity)player).add(diff).addY(player.func_213307_e(player.func_213283_Z())).addY(0.4f).add(offset);
                    }
                    return new Vector3();
                }
            });
        }
    }

    private boolean shouldDoEffect(PlayerEntity player) {
        return player.func_110124_au().equals(this.playerUUID) && (player.func_213283_Z() == Pose.STANDING || player.func_213283_Z() == Pose.CROUCHING) && !player.func_70644_a(Effects.field_76441_p);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PatreonEffect - Star halo " + this.playerUUID.toString();
    }
}

