/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ConstellationEffectEntityCollect;
import hellfirepvp.astralsorcery.common.data.config.registry.TechnicalEntityRegistry;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.DamageSourceUtil;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectDiscidia
extends ConstellationEffectEntityCollect<LivingEntity> {
    public static DiscidiaConfig CONFIG = new DiscidiaConfig();

    public CEffectDiscidia(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.discidia, LivingEntity.class, entity -> entity.func_70089_S() && TechnicalEntityRegistry.INSTANCE.canAffect((Entity)entity));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        Vector3 playAt = new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5);
        if (pos.equals((Object)pedestal.func_174877_v())) {
            playAt.add((double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)(rand.nextFloat() * 5.0f), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1));
        }
        Vector3 motion = Vector3.random().setY(0).multiply(0.05);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(playAt)).alpha(VFXAlphaFunction.FADE_OUT)).motion(VFXMotionController.decelerate(() -> motion))).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_DISCIDIA))).setScaleMultiplier(0.4f)).setMaxAge(35);
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        boolean didEffect = false;
        float damage = ((Double)CEffectDiscidia.CONFIG.damage.get()).floatValue();
        PlayerEntity owner = this.getOwningPlayerInWorld(world, pos);
        DamageSource src = owner == null ? CommonProxy.DAMAGE_SOURCE_STELLAR : DamageSourceUtil.withEntityDirect(CommonProxy.DAMAGE_SOURCE_STELLAR, (Entity)owner);
        List entities = this.collectEntities(world, pos, properties);
        for (LivingEntity entity : entities) {
            if (rand.nextInt(10) != 0) continue;
            if (properties.isCorrupted()) {
                entity.func_70691_i(damage);
                entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 30, 1));
            } else {
                if (entity instanceof PlayerEntity && !MiscUtils.canPlayerAttackServer(null, entity)) continue;
                DamageUtil.shotgunAttack(entity, e -> DamageUtil.attackEntityFrom((Entity)entity, src, damage));
            }
            didEffect = true;
        }
        return didEffect;
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class DiscidiaConfig
    extends ConstellationEffect.Config {
        private final double defaultDamage = 3.0;
        public ForgeConfigSpec.DoubleValue damage;

        public DiscidiaConfig() {
            super("discidia", 10.0, 2.0);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.damage = cfgBuilder.comment("Defines the max. possible damage dealt per damage tick.").translation(this.translationKey("damage")).defineInRange("damage", this.defaultDamage, 0.1, 128.0);
        }
    }
}

