/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.data.config.base.ConfiguredBlockStateList;
import hellfirepvp.astralsorcery.common.data.config.registry.OreBlockRarityRegistry;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockStateList;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockLayerPositionGenerator;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockRandomPositionGenerator;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectMineralis
extends CEffectAbstractList<ListEntries.PosEntry> {
    public static MineralisConfig CONFIG = new MineralisConfig(new BlockStateList().add(Blocks.field_150348_b));

    public CEffectMineralis(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.mineralis, (Integer)CEffectMineralis.CONFIG.maxAmount.get(), (world, pos, state) -> true);
        this.excludeRitualColumn();
        this.selectSphericalPositions();
    }

    @Override
    @Nonnull
    protected BlockPositionGenerator createPositionStrategy() {
        return new BlockLayerPositionGenerator();
    }

    @Override
    @Nonnull
    protected BlockPositionGenerator selectPositionStrategy(BlockPositionGenerator defaultGenerator, ConstellationEffectProperties properties) {
        if (!properties.isCorrupted()) {
            return new BlockRandomPositionGenerator();
        }
        return defaultGenerator;
    }

    @Override
    @Nullable
    public ListEntries.PosEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @Nullable
    public ListEntries.PosEntry createElement(World world, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        if (rand.nextFloat() < 0.6f) {
            Color c = (Color)MiscUtils.eitherOf(rand, () -> ColorsAS.CONSTELLATION_MINERALIS, () -> ColorsAS.CONSTELLATION_MINERALIS.brighter());
            Vector3 at = Vector3.random().normalize().multiply((double)rand.nextFloat() * prop.getSize()).add((Vec3i)pos).add(0.5, 0.5, 0.5);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(Vector3.random().multiply(0.05f))).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.5f + rand.nextFloat() * 0.25f)).setMaxAge(50 + rand.nextInt(40));
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        return this.peekNewPosition(world, pos, properties).mapLeft(entry -> {
            BlockPos at = entry.getPos();
            BlockState atState = world.func_180495_p(at);
            if (properties.isCorrupted()) {
                if (world.func_175623_d(entry.getPos())) {
                    if (rand.nextInt(25) == 0) {
                        Block ore = OreBlockRarityRegistry.MINERALIS_RITUAL.getRandomBlock(rand);
                        if (ore != null) {
                            return world.func_175656_a(at, ore.func_176223_P());
                        }
                        return world.func_175656_a(at, Blocks.field_150348_b.func_176223_P());
                    }
                    return world.func_175656_a(at, Blocks.field_150348_b.func_176223_P());
                }
            } else if (CONFIG.replaceableStates.test(atState)) {
                Block ore = OreBlockRarityRegistry.MINERALIS_RITUAL.getRandomBlock(rand);
                if (ore != null) {
                    return world.func_175656_a(at, ore.func_176223_P());
                }
                this.sendConstellationPing((IWorld)world, new Vector3((Vec3i)at).add(0.5, 0.5, 0.5));
            } else {
                this.sendConstellationPing((IWorld)world, new Vector3((Vec3i)at).add(0.5, 0.5, 0.5));
            }
            return false;
        }).ifRight(attemptedBreak -> this.sendConstellationPing((IWorld)world, new Vector3((Vec3i)attemptedBreak).add(0.5, 0.5, 0.5))).left().orElse(false);
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class MineralisConfig
    extends CEffectAbstractList.CountConfig {
        private final BlockStateList defaultReplaceableStates;
        private ConfiguredBlockStateList replaceableStates;

        public MineralisConfig(BlockStateList defaultReplaceableStates) {
            super("mineralis", 6.0, 4.0, 1);
            this.defaultReplaceableStates = defaultReplaceableStates;
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.replaceableStates = this.defaultReplaceableStates.getAsConfig(cfgBuilder, "replaceableStates", this.translationKey("replaceableStates"), "Defines the blockstates that may be replaced by generated ore from the ritual.");
        }
    }
}

