/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectOctans
extends MantleEffect {
    public static OctansConfig CONFIG = new OctansConfig();

    public MantleEffectOctans() {
        super(ConstellationsAS.octans);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(this::handleUnderwaterBreakSpeed);
        bus.addListener(this::handleUnderwaterUnwavering);
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        super.tickServer(player);
        if (player.func_208600_a(FluidTags.field_206959_a)) {
            if (player.func_70086_ai() < player.func_205010_bg() - 20) {
                player.func_70050_g(player.func_205010_bg());
            }
            player.func_70691_i(((Double)MantleEffectOctans.CONFIG.healPerTick.get()).floatValue());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        float chance = 0.1f;
        if (player.func_208600_a(FluidTags.field_206959_a)) {
            chance = 0.3f;
        }
        this.playCapeSparkles(player, chance);
    }

    private void handleUnderwaterBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
            LogicalSide side = player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
            MantleEffectOctans octans = (MantleEffectOctans)((Object)ItemMantle.getEffect((LivingEntity)player, ConstellationsAS.octans));
            if (octans != null && AlignmentChargeHandler.INSTANCE.hasCharge(player, side, ((Integer)MantleEffectOctans.CONFIG.chargeCostPerBreakSpeed.get()).intValue())) {
                ItemStack existing = player.func_184582_a(EquipmentSlotType.HEAD);
                ItemStack st = new ItemStack((IItemProvider)Items.field_151024_Q);
                st.func_77966_a(Enchantments.field_185299_g, 1);
                player.field_71071_by.field_70460_b.set(EquipmentSlotType.HEAD.func_188454_b(), (Object)st);
                EventFlags.CHECK_UNDERWATER_BREAK_SPEED.executeWithFlag(() -> {
                    event.setNewSpeed(player.getDigSpeed(event.getState(), event.getPos()));
                    AlignmentChargeHandler.INSTANCE.drainCharge(player, side, ((Integer)MantleEffectOctans.CONFIG.chargeCostPerBreakSpeed.get()).intValue(), false);
                });
                player.field_71071_by.field_70460_b.set(EquipmentSlotType.HEAD.func_188454_b(), (Object)existing);
            }
        }
    }

    private void handleUnderwaterUnwavering(LivingKnockBackEvent event) {
        MantleEffectOctans octans;
        if (event.getEntityLiving().func_208600_a(FluidTags.field_206959_a) && (octans = (MantleEffectOctans)((Object)ItemMantle.getEffect(event.getEntityLiving(), ConstellationsAS.octans))) != null) {
            event.setCanceled(true);
        }
    }

    public static boolean shouldPreventWaterSlowdown(ItemStack elytraStack, LivingEntity wearingEntity) {
        if (elytraStack.func_77973_b() instanceof ItemMantle) {
            Object effect = ItemMantle.getEffect(wearingEntity, ConstellationsAS.octans);
            return effect != null;
        }
        return false;
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    public static class OctansConfig
    extends MantleEffect.Config {
        private final double defaultHealPerTick = 0.01f;
        private final int defaultChargeCostPerBreakSpeed = 30;
        public ForgeConfigSpec.DoubleValue healPerTick;
        public ForgeConfigSpec.IntValue chargeCostPerBreakSpeed;

        public OctansConfig() {
            super("octans");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.healPerTick = cfgBuilder.comment("Defines the amount of health that is healed while the wearer is in water. Can be set to 0 to disable this.").translation(this.translationKey("healPerTick")).defineInRange("healPerTick", this.defaultHealPerTick, 0.0, 5.0);
            this.chargeCostPerBreakSpeed = cfgBuilder.comment("Set the amount alignment charge consumed per accelerated underwater block breaking").translation(this.translationKey("chargeCostPerBreakSpeed")).defineInRange("chargeCostPerBreakSpeed", this.defaultChargeCostPerBreakSpeed, 0, 1000);
        }
    }
}

