/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.entity.EntitySpectralTool;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectPelotrio
extends MantleEffect {
    public static PelotrioConfig CONFIG = new PelotrioConfig();

    public MantleEffectPelotrio() {
        super(ConstellationsAS.pelotrio);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(this::onHurt);
        bus.addListener(this::onBreak);
    }

    private void onHurt(LivingAttackEvent event) {
        World world = event.getEntityLiving().func_130014_f_();
        if (world.func_201670_d()) {
            return;
        }
        LivingEntity attacked = event.getEntityLiving();
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof PlayerEntity) {
            if (attacked instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)attacked)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)attacker;
            if (ItemMantle.getEffect((LivingEntity)player, ConstellationsAS.pelotrio) != null && (double)rand.nextFloat() < (Double)MantleEffectPelotrio.CONFIG.chanceSpawnSword.get() && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerSword.get()).intValue()) && world.func_217376_c((Entity)new EntitySpectralTool(world, player.func_180425_c().func_177984_a(), (LivingEntity)player, EntitySpectralTool.ToolTask.createAttackTask()))) {
                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerSword.get()).intValue(), false);
            }
        }
    }

    private void onBreak(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        if (world.func_201670_d() || !(world instanceof World)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)player) || ItemMantle.getEffect((LivingEntity)player, ConstellationsAS.pelotrio) == null)) {
            BlockState state = event.getState();
            if ((state.getHarvestTool() == ToolType.AXE || state.func_185904_a().func_76229_l()) && (state.func_203425_a(BlockTags.field_200031_h) || state.func_203425_a(BlockTags.field_206952_E)) && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().getToolTypes().contains(ToolType.AXE)) {
                if ((double)rand.nextFloat() < (Double)MantleEffectPelotrio.CONFIG.chanceSpawnAxe.get() && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerAxe.get()).intValue()) && world.func_217376_c((Entity)new EntitySpectralTool((World)world, player.func_180425_c(), (LivingEntity)player, EntitySpectralTool.ToolTask.createLogTask()))) {
                    AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerAxe.get()).intValue(), false);
                }
                return;
            }
            if ((state.getHarvestTool() == ToolType.PICKAXE || state.func_185904_a().func_76229_l()) && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().getToolTypes().contains(ToolType.PICKAXE) && (double)rand.nextFloat() < (Double)MantleEffectPelotrio.CONFIG.chanceSpawnPickaxe.get() && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerPickaxe.get()).intValue()) && world.func_217376_c((Entity)new EntitySpectralTool((World)world, player.func_180425_c(), (LivingEntity)player, EntitySpectralTool.ToolTask.createPickaxeTask()))) {
                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectPelotrio.CONFIG.chargeCostPerPickaxe.get()).intValue(), false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.15f);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class PelotrioConfig
    extends MantleEffect.Config {
        private final double defaultChanceSpawnSword = 0.6;
        private final double defaultChanceSpawnPickaxe = 0.8;
        private final double defaultChanceSpawnAxe = 0.8;
        private final double defaultSpeedSword = 2.3;
        private final double defaultSpeedPick = 1.8;
        private final double defaultSpeedAxe = 1.8;
        private final double defaultSwordDamage = 4.0;
        private final int defaultDurationSword = 100;
        private final int defaultDurationPickaxe = 100;
        private final int defaultDurationAxe = 100;
        private final int defaultTicksPerSwordAttack = 6;
        private final int defaultTicksPerPickaxeBlockBreak = 4;
        private final int defaultTicksPerAxeLogBreak = 2;
        private final int defaultChargeCostPerSword = 250;
        private final int defaultChargeCostPerPickaxe = 250;
        private final int defaultChargeCostPerAxe = 250;
        public ForgeConfigSpec.DoubleValue chanceSpawnSword;
        public ForgeConfigSpec.DoubleValue chanceSpawnPickaxe;
        public ForgeConfigSpec.DoubleValue chanceSpawnAxe;
        public ForgeConfigSpec.DoubleValue speedSword;
        public ForgeConfigSpec.DoubleValue speedPickaxe;
        public ForgeConfigSpec.DoubleValue speedAxe;
        public ForgeConfigSpec.DoubleValue swordDamage;
        public ForgeConfigSpec.IntValue durationSword;
        public ForgeConfigSpec.IntValue durationPickaxe;
        public ForgeConfigSpec.IntValue durationAxe;
        public ForgeConfigSpec.IntValue ticksPerSwordAttack;
        public ForgeConfigSpec.IntValue ticksPerPickaxeBlockBreak;
        public ForgeConfigSpec.IntValue ticksPerAxeLogBreak;
        public ForgeConfigSpec.IntValue chargeCostPerSword;
        public ForgeConfigSpec.IntValue chargeCostPerPickaxe;
        public ForgeConfigSpec.IntValue chargeCostPerAxe;

        public PelotrioConfig() {
            super("pelotrio");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.chanceSpawnSword = cfgBuilder.comment("Defines the chance of a spectral sword spawning that fights mobs nearby for a while when you attack a mob.").translation(this.translationKey("chanceSpawnSword")).defineInRange("chanceSpawnSword", this.defaultChanceSpawnSword, 0.0, 1.0);
            ForgeConfigSpec.Builder builder = cfgBuilder.comment("Defines the chance of a spectral pickaxe spawning that's mining for you for a bit when you mine a block.").translation(this.translationKey("chanceSpawnPickaxe"));
            this.getClass();
            this.chanceSpawnPickaxe = builder.defineInRange("chanceSpawnPickaxe", 0.8, 0.0, 1.0);
            ForgeConfigSpec.Builder builder2 = cfgBuilder.comment("Defines the chance of a spectral axe spawning that's chopping logs and leaves for you for a bit when you break a log or leaf.").translation(this.translationKey("chanceSpawnAxe"));
            this.getClass();
            this.chanceSpawnAxe = builder2.defineInRange("chanceSpawnAxe", 0.8, 0.0, 1.0);
            this.speedSword = cfgBuilder.comment("Defines the movement/flying speed of a spawned spectral sword.").translation(this.translationKey("speedSword")).defineInRange("speedSword", this.defaultSpeedSword, 0.5, 4.5);
            ForgeConfigSpec.Builder builder3 = cfgBuilder.comment("Defines the movement/flying speed of a spawned spectral pickaxe.").translation(this.translationKey("speedPickaxe"));
            this.getClass();
            this.speedPickaxe = builder3.defineInRange("speedPickaxe", 1.8, 0.5, 4.5);
            ForgeConfigSpec.Builder builder4 = cfgBuilder.comment("Defines the movement/flying speed of a spawned spectral axe.").translation(this.translationKey("speedAxe"));
            this.getClass();
            this.speedAxe = builder4.defineInRange("speedAxe", 1.8, 0.5, 4.5);
            this.swordDamage = cfgBuilder.comment("Defines the damage the sword does per attack.").translation(this.translationKey("swordDamage")).defineInRange("swordDamage", this.defaultSwordDamage, 0.1, 32.0);
            ForgeConfigSpec.Builder builder5 = cfgBuilder.comment("Defines the duration a spawned spectral sword is alive for. It will stay around this amount plus randomly twice this amount of ticks.").translation(this.translationKey("durationSword"));
            this.getClass();
            this.durationSword = builder5.defineInRange("durationSword", 100, 20, 500);
            ForgeConfigSpec.Builder builder6 = cfgBuilder.comment("Defines the duration a spawned spectral pickaxe is alive for. It will stay around this amount plus randomly twice this amount of ticks.").translation(this.translationKey("durationPickaxe"));
            this.getClass();
            this.durationPickaxe = builder6.defineInRange("durationPickaxe", 100, 20, 500);
            ForgeConfigSpec.Builder builder7 = cfgBuilder.comment("Defines the duration a spawned spectral axe is alive for. It will stay around this amount plus randomly twice this amount of ticks.").translation(this.translationKey("durationAxe"));
            this.getClass();
            this.durationAxe = builder7.defineInRange("durationAxe", 100, 20, 500);
            this.ticksPerSwordAttack = cfgBuilder.comment("Defines how many ticks are at least between sword attacks the sword makes.").translation(this.translationKey("ticksPerSwordAttack")).defineInRange("ticksPerSwordAttack", this.defaultTicksPerSwordAttack, 1, 100);
            this.ticksPerPickaxeBlockBreak = cfgBuilder.comment("Defines how long a pickaxe needs to break a block.").translation(this.translationKey("ticksPerPickaxeBlockBreak")).defineInRange("ticksPerPickaxeBlockBreak", this.defaultTicksPerPickaxeBlockBreak, 1, 100);
            this.ticksPerAxeLogBreak = cfgBuilder.comment("Defines how long an axe is going to need to break a leaf or log.").translation(this.translationKey("ticksPerAxeLogBreak")).defineInRange("ticksPerAxeLogBreak", this.defaultTicksPerAxeLogBreak, 1, 100);
            ForgeConfigSpec.Builder builder8 = cfgBuilder.comment("Set the amount alignment charge consumed per created spectral sword").translation(this.translationKey("chargeCostPerSword"));
            this.getClass();
            this.chargeCostPerSword = builder8.defineInRange("chargeCostPerSword", 250, 0, 1000);
            ForgeConfigSpec.Builder builder9 = cfgBuilder.comment("Set the amount alignment charge consumed per created spectral sword").translation(this.translationKey("chargeCostPerPickaxe"));
            this.getClass();
            this.chargeCostPerPickaxe = builder9.defineInRange("chargeCostPerPickaxe", 250, 0, 1000);
            ForgeConfigSpec.Builder builder10 = cfgBuilder.comment("Set the amount alignment charge consumed per created spectral sword").translation(this.translationKey("chargeCostPerAxe"));
            this.getClass();
            this.chargeCostPerAxe = builder10.defineInRange("chargeCostPerAxe", 250, 0, 1000);
        }
    }
}

