/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.helper.EventHelperTemporaryFlight;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyMantleFlight;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectVicio
extends MantleEffect {
    public static VicioConfig CONFIG = new VicioConfig();

    public MantleEffectVicio() {
        super(ConstellationsAS.vicio);
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        super.tickServer(player);
        PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (prog.hasPerkEffect(p -> p instanceof KeyMantleFlight) && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true)) {
            boolean prev = player.field_71075_bZ.field_75101_c;
            player.field_71075_bZ.field_75101_c = true;
            if (!prev) {
                player.func_71016_p();
            }
            EventHelperTemporaryFlight.allowFlight(player, 10);
            if (player.field_71075_bZ.field_75100_b && !player.field_70122_E && player.field_70173_aa % 10 == 0) {
                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        if (player.func_184613_cA() || !player.func_184812_l_() && !player.func_175149_v() && player.field_71075_bZ.field_75100_b) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                this.playCapeSparkles(player, 0.1f);
            } else {
                this.playCapeSparkles(player, 0.7f);
            }
        } else {
            this.playCapeSparkles(player, 0.15f);
        }
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    protected FXFacingParticle spawnFacingParticle(PlayerEntity player, Vector3 at) {
        if (player.func_184613_cA() || !player.func_184812_l_() && !player.func_175149_v() && player.field_71075_bZ.field_75100_b) {
            at.subtract(player.func_213322_ci().func_216372_d(1.5, 1.5, 1.5));
        }
        return super.spawnFacingParticle(player, at);
    }

    public static boolean isUsableElytra(ItemStack elytraStack, PlayerEntity wearingEntity) {
        if (elytraStack.func_77973_b() instanceof ItemMantle) {
            Object effect = ItemMantle.getEffect((LivingEntity)wearingEntity, (IWeakConstellation)ConstellationsAS.vicio);
            PlayerProgress progress = wearingEntity.func_130014_f_().func_201670_d() ? ResearchHelper.getClientProgress() : ResearchHelper.getProgress(wearingEntity, LogicalSide.SERVER);
            return effect != null && !progress.hasPerkEffect(p -> p instanceof KeyMantleFlight);
        }
        return false;
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    private static class VicioConfig
    extends MantleEffect.Config {
        private static final int defaultChargeCost = 60;
        private ForgeConfigSpec.IntValue chargeCost;

        public VicioConfig() {
            super("vicio");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per !second! during creative-flight with the vicio mantle.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 60, 1, 500);
        }
    }
}

