/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomMatcherRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResult;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.InteractionResultRegistry;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquidInteraction
extends CustomMatcherRecipe {
    private static final Random rand = new Random();
    private final FluidStack reactant1;
    private final FluidStack reactant2;
    private final float chanceConsumeReactant1;
    private final float chanceConsumeReactant2;
    private final int weight;
    private final InteractionResult result;

    public LiquidInteraction(ResourceLocation recipeId, FluidStack reactant1, float chanceConsumeReactant1, FluidStack reactant2, float chanceConsumeReactant2, int weight, InteractionResult result) {
        super(recipeId);
        this.reactant1 = reactant1;
        this.chanceConsumeReactant1 = chanceConsumeReactant1;
        this.reactant2 = reactant2;
        this.chanceConsumeReactant2 = chanceConsumeReactant2;
        this.weight = weight;
        this.result = result;
    }

    public boolean matches(FluidStack input1, FluidStack input2) {
        return input1.containsFluid(this.reactant1) && input2.containsFluid(this.reactant2) || input2.containsFluid(this.reactant2) && input1.containsFluid(this.reactant1);
    }

    public boolean consumeInputs(TileChalice chalice1, TileChalice chalice2) {
        FluidStack drained2;
        FluidStack drained1;
        FluidStack contained2;
        FluidStack contained1 = chalice1.getTank().getFluid();
        if (!this.matches(contained1, contained2 = chalice2.getTank().getFluid())) {
            return false;
        }
        if (contained1.containsFluid(this.reactant1) && contained2.containsFluid(this.reactant2)) {
            drained1 = chalice1.getTank().drain(this.reactant1, IFluidHandler.FluidAction.SIMULATE);
            drained2 = chalice2.getTank().drain(this.reactant2, IFluidHandler.FluidAction.SIMULATE);
            if (drained1.containsFluid(this.reactant1) && drained2.containsFluid(this.reactant2)) {
                if (rand.nextFloat() < this.chanceConsumeReactant1) {
                    chalice1.getTank().drain(this.reactant1, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rand.nextFloat() < this.chanceConsumeReactant2) {
                    chalice2.getTank().drain(this.reactant2, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        if (contained1.containsFluid(this.reactant2) && contained2.containsFluid(this.reactant1)) {
            drained1 = chalice1.getTank().drain(this.reactant2, IFluidHandler.FluidAction.SIMULATE);
            drained2 = chalice2.getTank().drain(this.reactant1, IFluidHandler.FluidAction.SIMULATE);
            if (drained1.containsFluid(this.reactant2) && drained2.containsFluid(this.reactant1)) {
                if (rand.nextFloat() < this.chanceConsumeReactant1) {
                    chalice2.getTank().drain(this.reactant1, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rand.nextFloat() < this.chanceConsumeReactant2) {
                    chalice1.getTank().drain(this.reactant2, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        return false;
    }

    public FluidStack getReactant1() {
        return this.reactant1;
    }

    public FluidStack getReactant2() {
        return this.reactant2;
    }

    public InteractionResult getResult() {
        return this.result;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public static LiquidInteraction pickRecipe(Collection<LiquidInteraction> recipes) {
        return MiscUtils.getWeightedRandomEntry(recipes, rand, interaction -> interaction.weight);
    }

    public static LiquidInteraction read(ResourceLocation recipeId, JsonObject json) {
        String fluidKey1 = JSONUtils.func_151200_h((JsonObject)json, (String)"reactant1");
        Fluid reactant1 = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidKey1));
        if (reactant1 == null) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidKey1);
        }
        int amount1 = JSONUtils.func_151203_m((JsonObject)json, (String)"reactant1Amount");
        CompoundNBT tag1 = null;
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"reactant1Tag")) {
            String jsonTag1 = JSONUtils.func_151200_h((JsonObject)json, (String)"reactant1Tag");
            try {
                tag1 = JsonToNBT.func_180713_a((String)jsonTag1);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid Json: " + jsonTag1);
            }
        }
        FluidStack r1 = new FluidStack(reactant1, amount1, tag1);
        String fluidKey2 = JSONUtils.func_151200_h((JsonObject)json, (String)"reactant2");
        Fluid reactant2 = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidKey2));
        if (reactant2 == null) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidKey2);
        }
        int amount2 = JSONUtils.func_151203_m((JsonObject)json, (String)"reactant2Amount");
        CompoundNBT tag2 = null;
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"reactant2Tag")) {
            String jsonTag2 = JSONUtils.func_151200_h((JsonObject)json, (String)"reactant2Tag");
            try {
                tag2 = JsonToNBT.func_180713_a((String)jsonTag2);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid Json: " + jsonTag2);
            }
        }
        FluidStack r2 = new FluidStack(reactant2, amount2, tag2);
        float chance1 = JSONUtils.func_151217_k((JsonObject)json, (String)"chanceConsumeReactant1");
        float chance2 = JSONUtils.func_151217_k((JsonObject)json, (String)"chanceConsumeReactant2");
        int weight = JSONUtils.func_151203_m((JsonObject)json, (String)"weight");
        JsonObject ctResult = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)ctResult, (String)"id"));
        InteractionResult result = InteractionResultRegistry.create(id);
        if (result == null) {
            throw new JsonSyntaxException("Unknown result type: " + id.toString() + "; expected one of " + Strings.join(InteractionResultRegistry.getKeysAsStrings(), (String)", "));
        }
        JsonObject resultData = JSONUtils.func_152754_s((JsonObject)ctResult, (String)"data");
        result.read(resultData);
        return new LiquidInteraction(recipeId, r1, chance1, r2, chance2, weight, result);
    }

    public final void write(JsonObject object) {
        object.addProperty("reactant1", this.reactant1.getFluid().getRegistryName().toString());
        object.addProperty("reactant1Amount", (Number)this.reactant1.getAmount());
        if (this.reactant1.hasTag()) {
            object.addProperty("reactant1Tag", this.reactant1.getTag().toString());
        }
        object.addProperty("reactant2", this.reactant2.getFluid().getRegistryName().toString());
        object.addProperty("reactant2Amount", (Number)this.reactant2.getAmount());
        if (this.reactant2.hasTag()) {
            object.addProperty("reactant2Tag", this.reactant2.getTag().toString());
        }
        object.addProperty("chanceConsumeReactant1", (Number)Float.valueOf(this.chanceConsumeReactant1));
        object.addProperty("chanceConsumeReactant2", (Number)Float.valueOf(this.chanceConsumeReactant2));
        object.addProperty("weight", (Number)this.weight);
        JsonObject ctResult = new JsonObject();
        ctResult.addProperty("id", this.result.getId().toString());
        JsonObject resultObj = new JsonObject();
        this.result.write(resultObj);
        ctResult.add("data", (JsonElement)resultObj);
        object.add("result", (JsonElement)ctResult);
    }

    public static LiquidInteraction read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack reactant1 = ByteBufUtils.readFluidStack(buffer);
        FluidStack reactant2 = ByteBufUtils.readFluidStack(buffer);
        float chanceConsumeReactant1 = buffer.readFloat();
        float chanceConsumeReactant2 = buffer.readFloat();
        int weight = buffer.readInt();
        ResourceLocation key = new ResourceLocation(ByteBufUtils.readString(buffer));
        InteractionResult result = InteractionResultRegistry.create(key);
        if (result == null) {
            return null;
        }
        result.read(buffer);
        return new LiquidInteraction(recipeId, reactant1, chanceConsumeReactant1, reactant2, chanceConsumeReactant2, weight, result);
    }

    public final void write(PacketBuffer buffer) {
        ByteBufUtils.writeFluidStack(buffer, this.reactant1);
        ByteBufUtils.writeFluidStack(buffer, this.reactant2);
        buffer.writeFloat(this.chanceConsumeReactant1);
        buffer.writeFloat(this.chanceConsumeReactant2);
        buffer.writeInt(this.weight);
        ByteBufUtils.writeString(buffer, this.result.getId().toString());
        this.result.write(buffer);
    }

    @Override
    public CustomRecipeSerializer<?> getSerializer() {
        return RecipeSerializersAS.LIQUID_INTERACTION_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypesAS.TYPE_LIQUID_INTERACTION.getType();
    }
}

