/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.crystal.CalculationContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class CrystalAttributes {
    private static final Random rand = new Random();
    private LinkedList<Attribute> crystalAttributes = Lists.newLinkedList();

    private CrystalAttributes() {
    }

    private CrystalAttributes(Map<CrystalProperty, Integer> crystalAttributes) {
        this.crystalAttributes = Lists.newLinkedList();
        for (Map.Entry<CrystalProperty, Integer> propertyEntry : crystalAttributes.entrySet()) {
            this.crystalAttributes.add(new Attribute(propertyEntry.getKey(), propertyEntry.getValue(), false));
        }
        this.crystalAttributes.sort(Comparator.comparing(Attribute::getProperty));
    }

    public List<Attribute> getCrystalAttributes() {
        return Collections.unmodifiableList(this.crystalAttributes);
    }

    public List<CrystalProperty> getPropertiesPerTier(boolean combineDuplicates) {
        ArrayList<CrystalProperty> properties = new ArrayList<CrystalProperty>(!combineDuplicates ? this.getTotalTierLevel() : this.getCrystalAttributes().size());
        for (Attribute attribute : this.getCrystalAttributes()) {
            if (combineDuplicates) {
                properties.add(attribute.getProperty());
                continue;
            }
            for (int i = 0; i < attribute.getTier(); ++i) {
                properties.add(attribute.getProperty());
            }
        }
        return properties;
    }

    @Nullable
    public Attribute getAttribute(CrystalProperty property) {
        for (Attribute attr : this.crystalAttributes) {
            if (!attr.getProperty().equals(property)) continue;
            return attr;
        }
        return null;
    }

    public int getTotalTierLevel() {
        int tier = 0;
        for (Attribute attr : this.getCrystalAttributes()) {
            tier += attr.getTier();
        }
        return tier;
    }

    public CrystalAttributes discoverAll(PlayerProgress prog) {
        if (MiscUtils.contains(this.getCrystalAttributes(), attr -> ((Attribute)attr).canNewDiscover(prog))) {
            CrystalAttributes thisCopy = this.copy();
            thisCopy.crystalAttributes.forEach(attribute -> ((Attribute)attribute).discover(prog));
            return thisCopy;
        }
        return this;
    }

    public boolean hasUnknownAttributes() {
        return MiscUtils.contains(this.getCrystalAttributes(), attribute -> !attribute.isDiscovered());
    }

    public boolean isEmpty() {
        return this.getTotalTierLevel() <= 0;
    }

    public List<CrystalProperty> getProperties() {
        return this.getCrystalAttributes().stream().map(Attribute::getProperty).collect(Collectors.toList());
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TooltipResult addTooltip(List<ITextComponent> tooltip) {
        return this.addTooltip(tooltip, CalculationContext.Builder.newBuilder().build());
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TooltipResult addTooltip(List<ITextComponent> tooltip, PlayerProgress progress) {
        return this.addTooltip(tooltip, progress, CalculationContext.Builder.newBuilder().build());
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TooltipResult addTooltip(List<ITextComponent> tooltip, CalculationContext ctx) {
        return this.addTooltip(tooltip, ResearchHelper.getClientProgress(), ctx);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    private TooltipResult addTooltip(List<ITextComponent> tooltip, PlayerProgress progress, CalculationContext ctx) {
        boolean missing = false;
        boolean addedAtLeastOne = false;
        for (Attribute attr : this.getCrystalAttributes()) {
            if (attr.getTier() <= 0) continue;
            CrystalProperty prop = attr.getProperty();
            if (!prop.canSee(progress) || !attr.isDiscovered()) {
                missing = true;
                continue;
            }
            ITextComponent enchantmentLevel = new TranslationTextComponent(String.format("enchantment.level.%s", String.valueOf(attr.getTier())), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
            ITextComponent propertyName = prop.getName(attr.getTier()).func_211708_a(TextFormatting.GRAY);
            if (!prop.hasUsageFor(ctx) && !ctx.isEmpty()) continue;
            tooltip.add(propertyName.func_150257_a((ITextComponent)new StringTextComponent(" ")).func_150257_a(enchantmentLevel));
            addedAtLeastOne = true;
        }
        if (missing) {
            tooltip.add(new TranslationTextComponent("astralsorcery.progress.missing.knowledge", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        return missing && !addedAtLeastOne ? TooltipResult.ALL_MISSING : (missing ? TooltipResult.ADDED_ALL_WITH_MISSING : TooltipResult.ADDED_ALL);
    }

    public CrystalAttributes combine(CrystalAttributes other, boolean ignoreTierMax) {
        return this.combine(other, ignoreTierMax, 1.0f);
    }

    public CrystalAttributes combine(CrystalAttributes other, boolean ignoreTierMax, float mergeChance) {
        List<Attribute> otherAttributes = other.getCrystalAttributes();
        if (otherAttributes.isEmpty()) {
            return this.copy();
        }
        Builder builder = Builder.newBuilder(ignoreTierMax);
        builder.addAll(this.copy());
        for (Attribute otherAttr : otherAttributes) {
            for (int i = 0; i < otherAttr.getTier(); ++i) {
                if (!(rand.nextFloat() <= mergeChance)) continue;
                builder.addProperty(otherAttr.getProperty(), 1);
            }
        }
        return builder.build();
    }

    public CrystalAttributes modifyLevel(CrystalProperty prop, int change) {
        return this.modifyLevel(prop, change, false);
    }

    public CrystalAttributes modifyLevel(CrystalProperty prop, int change, boolean ignoreTierMax) {
        Attribute existing = this.getAttribute(prop);
        if (existing != null && change != 0) {
            int newTier = MathHelper.func_76125_a((int)(existing.getTier() + change), (int)0, (int)(ignoreTierMax ? Integer.MAX_VALUE : prop.getMaxTier()));
            if (newTier <= 0) {
                return this.transform(Function.identity(), Lists.newArrayList(), Lists.newArrayList((Object[])new CrystalProperty[]{prop}));
            }
            if (newTier != existing.getTier()) {
                return this.transform(attribute -> {
                    if (attribute.getProperty().equals(prop)) {
                        ((Attribute)attribute).tier = newTier;
                    }
                    return attribute;
                });
            }
        } else if (change > 0) {
            return this.transform(Function.identity(), Lists.newArrayList((Object[])new Attribute[]{new Attribute(prop, MathHelper.func_76125_a((int)change, (int)0, (int)prop.getMaxTier()))}), Lists.newArrayList());
        }
        return this;
    }

    private CrystalAttributes transform(Function<Attribute, Attribute> modify) {
        return this.transform(modify, Lists.newArrayList(), Lists.newArrayList());
    }

    private CrystalAttributes transform(Function<Attribute, Attribute> modify, Collection<Attribute> additions, Collection<CrystalProperty> removals) {
        ArrayList current = Lists.newArrayList();
        for (Attribute attr2 : this.getCrystalAttributes()) {
            current.add(new Attribute(attr2.getProperty(), attr2.getTier()));
        }
        List modified = current.stream().map(modify).collect(Collectors.toList());
        for (Attribute added : additions) {
            Attribute existing = MiscUtils.iterativeSearch(modified, tpl -> tpl.getProperty().equals(added.getProperty()));
            if (existing != null) {
                Attribute attribute = existing;
                attribute.tier = attribute.tier + added.getTier();
                continue;
            }
            modified.add(new Attribute(added.getProperty(), added.getTier()));
        }
        modified.removeIf(attr -> removals.contains(attr.getProperty()));
        return new CrystalAttributes(modified.stream().collect(Collectors.toMap(Attribute::getProperty, Attribute::getTier)));
    }

    public CrystalAttributes copy() {
        return CrystalAttributes.deserialize(this.serialize());
    }

    public CrystalAttributes clampMaxTier() {
        CrystalAttributes attributes = this.copy();
        for (Attribute attr : attributes.crystalAttributes) {
            attr.tier = MathHelper.func_76125_a((int)attr.getTier(), (int)0, (int)attr.getProperty().getMaxTier());
        }
        return attributes;
    }

    public void store(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.store(NBTHelper.getPersistentData(stack));
        }
    }

    public void store(CompoundNBT baseTag) {
        baseTag.func_218657_a("crystalProperties", (INBT)this.serialize());
    }

    public static void storeNull(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CrystalAttributes.storeNull(NBTHelper.getPersistentData(stack));
        }
    }

    public static void storeNull(CompoundNBT baseTag) {
        baseTag.func_82580_o("crystalProperties");
    }

    @Nullable
    public static CrystalAttributes getCrystalAttributes(ItemStack stack) {
        return !stack.func_190926_b() ? CrystalAttributes.getCrystalAttributes(NBTHelper.getPersistentData(stack)) : null;
    }

    @Nullable
    public static CrystalAttributes getCrystalAttributes(CompoundNBT baseTag) {
        if (!baseTag.func_74764_b("crystalProperties")) {
            return null;
        }
        CompoundNBT tag = baseTag.func_74775_l("crystalProperties");
        if (tag.func_186856_d() == 0) {
            return null;
        }
        return CrystalAttributes.deserialize(tag);
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Attribute attr : this.crystalAttributes) {
            list.add((Object)attr.serialize());
        }
        tag.func_218657_a("attributes", (INBT)list);
        return tag;
    }

    public static CrystalAttributes deserialize(CompoundNBT tag) {
        CrystalAttributes attributes = new CrystalAttributes();
        ListNBT list = tag.func_150295_c("attributes", 10);
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = Attribute.deserialize(list.func_150305_b(i));
            if (attr == null) continue;
            attributes.crystalAttributes.add(attr);
        }
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrystalAttributes that = (CrystalAttributes)o;
        return Objects.equals(this.crystalAttributes, that.crystalAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.crystalAttributes);
    }

    public static class Attribute {
        private boolean discovered;
        private int tier;
        private CrystalProperty property;

        private Attribute(CrystalProperty property, int tier) {
            this(property, tier, false);
        }

        private Attribute(CrystalProperty property, int tier, boolean discovered) {
            this.tier = tier;
            this.property = property;
            this.discovered = true;
        }

        public CrystalProperty getProperty() {
            return this.property;
        }

        private boolean canNewDiscover(PlayerProgress prog) {
            return !this.isDiscovered() && this.property.canSee(prog);
        }

        private void discover(PlayerProgress prog) {
            if (!this.isDiscovered() && this.property.canSee(prog)) {
                this.discovered = true;
            }
        }

        public boolean isDiscovered() {
            return this.discovered;
        }

        public int getTier() {
            return this.tier;
        }

        private CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("property", this.property.getRegistryName().toString());
            tag.func_74768_a("pLevel", this.tier);
            tag.func_74757_a("discovered", this.discovered);
            return tag;
        }

        @Nullable
        private static Attribute deserialize(CompoundNBT tag) {
            ResourceLocation key = new ResourceLocation(tag.func_74779_i("property"));
            CrystalProperty prop = (CrystalProperty)RegistriesAS.REGISTRY_CRYSTAL_PROPERTIES.getValue(key);
            if (prop == null) {
                return null;
            }
            int tier = tag.func_74762_e("pLevel");
            boolean discovered = tag.func_74767_n("discovered");
            return new Attribute(prop, tier, discovered);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return this.discovered == attribute.discovered && this.tier == attribute.tier && Objects.equals(this.property, attribute.property);
        }

        public int hashCode() {
            return Objects.hash(this.discovered, this.tier, this.property);
        }
    }

    public static class Builder {
        private Map<CrystalProperty, Integer> properties = Maps.newHashMap();
        private final boolean ignoreTierCap;

        private Builder(boolean ignoreTierCap) {
            this.ignoreTierCap = ignoreTierCap;
        }

        public static Builder newBuilder(boolean ignoreTierCap) {
            return new Builder(ignoreTierCap);
        }

        public Builder addAll(CrystalAttributes other) {
            for (Attribute attr : other.getCrystalAttributes()) {
                CrystalProperty property = attr.getProperty();
                int cTier = this.properties.getOrDefault(property, 0);
                cTier = MathHelper.func_76125_a((int)(cTier + attr.getTier()), (int)0, (int)(this.ignoreTierCap ? Integer.MAX_VALUE : property.getMaxTier()));
                this.properties.put(property, cTier);
            }
            return this;
        }

        public Builder addProperty(CrystalProperty property, int tier) {
            int cTier = this.properties.getOrDefault(property, 0);
            cTier = MathHelper.func_76125_a((int)(cTier + tier), (int)0, (int)(this.ignoreTierCap ? Integer.MAX_VALUE : property.getMaxTier()));
            this.properties.remove(property);
            if (cTier > 0) {
                this.properties.put(property, cTier);
            }
            return this;
        }

        public int getPropertyLvl(CrystalProperty property, int defaultValue) {
            return this.properties.getOrDefault(property, defaultValue);
        }

        public List<CrystalProperty> getProperties() {
            return Lists.newArrayList(this.properties.keySet());
        }

        public CrystalAttributes buildAverage(int count) {
            HashMap<CrystalProperty, Integer> average = new HashMap<CrystalProperty, Integer>();
            for (CrystalProperty prop : this.properties.keySet()) {
                int newLevel = MathHelper.func_76123_f((float)((float)this.properties.getOrDefault(prop, 0).intValue() / (float)count));
                if (newLevel <= 0) continue;
                average.put(prop, newLevel);
            }
            return new CrystalAttributes(average);
        }

        public CrystalAttributes build() {
            return new CrystalAttributes(this.properties);
        }
    }

    public static enum TooltipResult {
        ADDED_ALL,
        ADDED_ALL_WITH_MISSING,
        ALL_MISSING;

    }
}

