/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.FluidRarityEntry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class FluidRarityRegistry
extends ConfigDataAdapter<FluidRarityEntry> {
    public static final FluidRarityRegistry INSTANCE = new FluidRarityRegistry();

    private FluidRarityRegistry() {
    }

    @Override
    public List<FluidRarityEntry> getDefaultValues() {
        return Lists.newArrayList((Object[])new FluidRarityEntry[]{new FluidRarityEntry(Mods.MINECRAFT.key("water"), 14000, Integer.MAX_VALUE, Integer.MAX_VALUE), new FluidRarityEntry(Mods.MINECRAFT.key("lava"), 7500, 4000000, 1000000)});
    }

    @Override
    @Nullable
    public synchronized FluidRarityEntry getRandomValue(Random rand) {
        return MiscUtils.getWeightedRandomEntry(this.getConfiguredValues(), rand, FluidRarityEntry::getRarity);
    }

    @Override
    public String getSectionName() {
        return "fluid_rarities";
    }

    @Override
    public String getCommentDescription() {
        return "Defines fluid-rarities and amounts for the evershifting fountain's neromantic prime. The lower the relative rarity, the more rare the fluid. Format: <FluidName>;<guaranteedMbAmount>;<additionalRandomMbAmount>;<rarity>";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey("data");
    }

    @Override
    public FluidRarityEntry deserialize(String string) throws IllegalArgumentException {
        return FluidRarityEntry.deserialize(string);
    }

    @Override
    public Predicate<Object> getValidator() {
        return obj -> obj instanceof String;
    }
}

