/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class OreItemRarityEntry
implements ConfigDataSet {
    private final Tag<Item> itemTag;
    private final int weight;

    public OreItemRarityEntry(Tag<Item> itemTag, int weight) {
        this.itemTag = itemTag;
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public Item getRandomItem(Random rand) {
        return (Item)MiscUtils.getRandomEntry(this.itemTag.func_199885_a().stream().filter(item -> !((List)GeneralConfig.CONFIG.modidOreBlacklist.get()).contains(item.getRegistryName().func_110624_b())).collect(Collectors.toList()), rand);
    }

    @Nullable
    public static OreItemRarityEntry deserialize(String str) throws IllegalArgumentException {
        int weight;
        String[] split = str.split(";");
        if (split.length != 2) {
            return null;
        }
        ResourceLocation keyItemTag = new ResourceLocation(split[0]);
        Tag itemTag = ItemTags.func_199903_a().func_199910_a(keyItemTag);
        if (itemTag == null) {
            return null;
        }
        String strWeight = split[1];
        try {
            weight = Integer.parseInt(strWeight);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new OreItemRarityEntry((Tag<Item>)itemTag, weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.itemTag.func_199886_b().toString() + ";" + this.weight;
    }
}

