/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataRegistry;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.sync.server.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEntities;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncData;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class SyncDataHolder
implements ITickHandler {
    private static final SyncDataHolder tickInstance = new SyncDataHolder();
    public static final ResourceLocation DATA_LIGHT_CONNECTIONS = AstralSorcery.key("connections");
    public static final ResourceLocation DATA_LIGHT_BLOCK_ENDPOINTS = AstralSorcery.key("endpoints");
    public static final ResourceLocation DATA_TIME_FREEZE_EFFECTS = AstralSorcery.key("time_freeze");
    public static final ResourceLocation DATA_TIME_FREEZE_ENTITIES = AstralSorcery.key("time_freeze_entities");
    public static final ResourceLocation DATA_PATREON_FLARES = AstralSorcery.key("patreon");
    private static final Map<ResourceLocation, AbstractData> serverData = new HashMap<ResourceLocation, AbstractData>();
    private static final Map<ResourceLocation, ClientData<?>> clientData = new HashMap();
    private static final Map<ResourceLocation, ClientDataReader<?>> readers = new HashMap();
    private static final Set<ResourceLocation> dirtyData = new HashSet<ResourceLocation>();
    private static final Object lck = new Object();

    private SyncDataHolder() {
    }

    public static SyncDataHolder getTickInstance() {
        return tickInstance;
    }

    public static void register(AbstractDataProvider<? extends AbstractData, ? extends ClientData> provider) {
        SyncDataRegistry.register(provider);
        serverData.put(provider.getKey(), provider.provideServerData());
        clientData.put(provider.getKey(), provider.provideClientData());
        readers.put(provider.getKey(), provider.createReader());
    }

    public static <T extends AbstractData> void executeServer(ResourceLocation key, Class<T> typeHint, Consumer<T> fct) {
        SyncDataHolder.computeServer(key, typeHint, MiscUtils.nullFunction(fct));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractData, V> Optional<V> computeServer(ResourceLocation key, Class<T> typeHint, Function<T, V> fct) {
        Object object = lck;
        synchronized (object) {
            AbstractData dat = serverData.get(key);
            if (dat != null) {
                return Optional.ofNullable(fct.apply(dat));
            }
            return Optional.empty();
        }
    }

    public static <T extends ClientData<T>> void executeClient(ResourceLocation key, Class<T> typeHint, Consumer<T> fct) {
        SyncDataHolder.computeClient(key, typeHint, MiscUtils.nullFunction(fct));
    }

    public static <T extends ClientData<T>, V> Optional<V> computeClient(ResourceLocation key, Class<T> typeHint, Function<T, V> fct) {
        ClientData<?> dat = clientData.get(key);
        if (dat != null) {
            return Optional.ofNullable(fct.apply(dat));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T extends ClientData<T>> ClientDataReader<T> getReader(ResourceLocation key) {
        return readers.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForUpdate(ResourceLocation key) {
        Object object = lck;
        synchronized (object) {
            dirtyData.add(key);
        }
    }

    public static void clearWorld(IWorld world) {
        DimensionType dimType = world.func_201675_m().func_186058_p();
        for (ResourceLocation key : SyncDataRegistry.getKnownKeys()) {
            if (world.func_201670_d()) continue;
            SyncDataHolder.executeServer(key, AbstractData.class, data -> data.clear(dimType));
        }
    }

    public static void clear(LogicalSide side) {
        for (ResourceLocation key : SyncDataRegistry.getKnownKeys()) {
            if (side.isClient()) {
                SyncDataHolder.executeClient(key, ClientData.class, ClientData::clearClient);
                continue;
            }
            SyncDataHolder.executeServer(key, AbstractData.class, AbstractData::clearServer);
        }
    }

    public static void initialize() {
        SyncDataHolder.register(new DataLightConnections.Provider(DATA_LIGHT_CONNECTIONS));
        SyncDataHolder.register(new DataLightBlockEndpoints.Provider(DATA_LIGHT_BLOCK_ENDPOINTS));
        SyncDataHolder.register(new DataTimeFreezeEffects.Provider(DATA_TIME_FREEZE_EFFECTS));
        SyncDataHolder.register(new DataTimeFreezeEntities.Provider(DATA_TIME_FREEZE_ENTITIES));
        SyncDataHolder.register(new DataPatreonFlares.Provider(DATA_PATREON_FLARES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(TickEvent.Type type, Object ... context) {
        if (dirtyData.isEmpty()) {
            return;
        }
        HashMap<ResourceLocation, CompoundNBT> pktData = new HashMap<ResourceLocation, CompoundNBT>();
        Object object = lck;
        synchronized (object) {
            for (ResourceLocation key : dirtyData) {
                AbstractData dat = serverData.get(key);
                if (dat == null) continue;
                CompoundNBT nbt = new CompoundNBT();
                dat.writeDiffDataToPacket(nbt);
                pktData.put(key, nbt);
            }
            dirtyData.clear();
        }
        PktSyncData dataSync = new PktSyncData(pktData);
        PacketChannel.CHANNEL.sendToAll(dataSync);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Sync Data Holder";
    }
}

