/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientLightConnections;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;

public class DataLightConnections
extends AbstractData {
    private final Map<DimensionType, Map<BlockPos, Set<BlockPos>>> serverPosBuffer = new HashMap<DimensionType, Map<BlockPos, Set<BlockPos>>>();
    private final Map<DimensionType, LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>>> serverChangeBuffer = new HashMap<DimensionType, LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>>>();
    private final Set<DimensionType> dimensionClearBuffer = new HashSet<DimensionType>();

    private DataLightConnections(ResourceLocation key) {
        super(key);
    }

    public void updateNewConnectionsThreaded(DimensionType dimType, List<TransmissionChain.LightConnection> newlyAddedConnections) {
        Map posBufferDim = this.serverPosBuffer.computeIfAbsent(dimType, k -> new HashMap());
        for (TransmissionChain.LightConnection c : newlyAddedConnections) {
            BlockPos start = c.getStart();
            Set endpoints = posBufferDim.computeIfAbsent(start, k -> new HashSet());
            endpoints.add(c.getEnd());
        }
        this.notifyConnectionAdd(dimType, newlyAddedConnections);
        if (newlyAddedConnections.size() > 0) {
            this.markDirty();
        }
    }

    public void removeOldConnectionsThreaded(DimensionType dimType, List<TransmissionChain.LightConnection> invalidConnections) {
        Map<BlockPos, Set<BlockPos>> posBufferDim = this.serverPosBuffer.get(dimType);
        if (posBufferDim != null) {
            for (TransmissionChain.LightConnection c : invalidConnections) {
                BlockPos start = c.getStart();
                Set<BlockPos> ends = posBufferDim.get(start);
                if (ends == null) continue;
                ends.remove(c.getEnd());
                if (!ends.isEmpty()) continue;
                posBufferDim.remove(start);
            }
        }
        this.notifyConnectionRemoval(dimType, invalidConnections);
        if (invalidConnections.size() > 0) {
            this.markDirty();
        }
    }

    @Override
    public void clear(DimensionType dimType) {
        if (this.serverPosBuffer.remove(dimType) != null) {
            this.dimensionClearBuffer.add(dimType);
            this.markDirty();
        }
    }

    @Override
    public void clearServer() {
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
        this.serverPosBuffer.clear();
    }

    private void notifyConnectionAdd(DimensionType dimType, List<TransmissionChain.LightConnection> added) {
        LinkedList ch = this.serverChangeBuffer.computeIfAbsent(dimType, k -> new LinkedList());
        for (TransmissionChain.LightConnection l : added) {
            ch.add(new Tuple((Object)l, (Object)true));
        }
        this.dimensionClearBuffer.remove(dimType);
    }

    private void notifyConnectionRemoval(DimensionType dimType, List<TransmissionChain.LightConnection> removal) {
        LinkedList ch = this.serverChangeBuffer.computeIfAbsent(dimType, k -> new LinkedList());
        for (TransmissionChain.LightConnection l : removal) {
            ch.add(new Tuple((Object)l, (Object)false));
        }
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        for (DimensionType dimType : this.serverPosBuffer.keySet()) {
            Map<BlockPos, Set<BlockPos>> dat = this.serverPosBuffer.get(dimType);
            ListNBT dataList = new ListNBT();
            for (BlockPos start : dat.keySet()) {
                Set<BlockPos> endPositions = dat.get(start);
                if (endPositions == null) continue;
                for (BlockPos end : endPositions) {
                    CompoundNBT cmp = new CompoundNBT();
                    cmp.func_74772_a("start", start.func_218275_a());
                    cmp.func_74772_a("end", end.func_218275_a());
                    dataList.add((Object)cmp);
                }
            }
            compound.func_218657_a(dimType.getRegistryName().toString(), (INBT)dataList);
        }
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        ListNBT clearList = new ListNBT();
        for (DimensionType dimType : this.dimensionClearBuffer) {
            clearList.add((Object)StringNBT.func_229705_a_((String)dimType.getRegistryName().toString()));
        }
        compound.func_218657_a("clear", (INBT)clearList);
        for (DimensionType dimType : this.serverChangeBuffer.keySet()) {
            LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>> changes;
            if (this.dimensionClearBuffer.contains(dimType) || (changes = this.serverChangeBuffer.get(dimType)).isEmpty()) continue;
            ListNBT list = new ListNBT();
            for (Tuple tuple : changes) {
                CompoundNBT connection = new CompoundNBT();
                connection.func_74772_a("start", ((TransmissionChain.LightConnection)tuple.func_76341_a()).getStart().func_218275_a());
                connection.func_74772_a("end", ((TransmissionChain.LightConnection)tuple.func_76341_a()).getEnd().func_218275_a());
                connection.func_74757_a("connect", ((Boolean)tuple.func_76340_b()).booleanValue());
                list.add((Object)connection);
            }
            compound.func_218657_a(dimType.getRegistryName().toString(), (INBT)list);
        }
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
    }

    public static class Provider
    extends AbstractDataProvider<DataLightConnections, ClientLightConnections> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataLightConnections provideServerData() {
            return new DataLightConnections(this.getKey());
        }

        @Override
        public ClientLightConnections provideClientData() {
            return new ClientLightConnections();
        }

        @Override
        public ClientDataReader<ClientLightConnections> createReader() {
            return new ClientLightConnections.Reader();
        }
    }
}

