/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.SectionWorldData;
import hellfirepvp.observerlib.common.data.base.WorldSection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RockCrystalBuffer
extends SectionWorldData<BufferSection> {
    public RockCrystalBuffer(WorldCacheDomain.SaveKey<?> key) {
        super(key, 6);
    }

    protected BufferSection createNewSection(int sectionX, int sectionZ) {
        return new BufferSection(sectionX, sectionZ);
    }

    public List<BlockPos> collectPositions(ChunkPos center, int chunkRadius) {
        LinkedList<BlockPos> out = new LinkedList<BlockPos>();
        for (int xx = -chunkRadius; xx <= chunkRadius; ++xx) {
            for (int zz = -chunkRadius; zz <= chunkRadius; ++zz) {
                ChunkPos other = new ChunkPos(center.field_77276_a + xx, center.field_77275_b + zz);
                BufferSection section = (BufferSection)this.getSection((Vec3i)other.func_180331_a(0, 0, 0));
                if (section == null) continue;
                out.addAll(section.crystalPositions);
            }
        }
        return out;
    }

    public void addOre(BlockPos pos) {
        BufferSection section = (BufferSection)this.getOrCreateSection((Vec3i)pos);
        section.crystalPositions.add(pos);
        this.markDirty(section);
    }

    public void removeOre(BlockPos pos) {
        BufferSection section = (BufferSection)this.getSection((Vec3i)pos);
        if (section != null) {
            section.crystalPositions.remove(pos);
            this.markDirty(section);
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
    }

    public void readFromNBT(CompoundNBT nbt) {
    }

    public void updateTick(World world) {
    }

    public static class BufferSection
    extends WorldSection {
        private Set<BlockPos> crystalPositions = new HashSet<BlockPos>();

        private BufferSection(int sX, int sZ) {
            super(sX, sZ);
        }

        public void writeToNBT(CompoundNBT tag) {
            ListNBT posList = new ListNBT();
            for (BlockPos exactPos : this.crystalPositions) {
                posList.add((Object)NBTHelper.writeBlockPosToNBT(exactPos, new CompoundNBT()));
            }
            tag.func_218657_a("posList", (INBT)posList);
        }

        public void readFromNBT(CompoundNBT tag) {
            this.crystalPositions.clear();
            ListNBT entries = tag.func_150295_c("posList", 10);
            for (int j = 0; j < entries.size(); ++j) {
                this.crystalPositions.add(NBTHelper.readBlockPosFromNBT(entries.func_150305_b(j)));
            }
        }
    }
}

