/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AmuletEnchantment
extends DynamicEnchantment {
    public AmuletEnchantment(DynamicEnchantmentType type, @Nonnull Enchantment enchantment, int levelAddition) {
        super(type, enchantment, levelAddition);
    }

    public AmuletEnchantment(DynamicEnchantmentType type, int levelAddition) {
        super(type, levelAddition);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getDisplay() {
        String typeStr = this.getType().getDisplayName();
        String levelsStr = I18n.func_135052_a((String)String.format("astralsorcery.amulet.enchantment.level.%s", this.levelAddition > 1 ? "more" : "one"), (Object[])new Object[0]);
        if (this.getType().isEnchantmentSpecific()) {
            return I18n.func_135052_a((String)typeStr, (Object[])new Object[]{String.valueOf(this.getLevelAddition()), levelsStr, I18n.func_135052_a((String)this.getEnchantment().func_77320_a(), (Object[])new Object[0])});
        }
        return I18n.func_135052_a((String)typeStr, (Object[])new Object[]{String.valueOf(this.getLevelAddition()), levelsStr});
    }

    public boolean canMerge(AmuletEnchantment other) {
        return this.type.equals((Object)other.type) && (!this.type.isEnchantmentSpecific() || this.enchantment.equals(other.enchantment));
    }

    public void merge(AmuletEnchantment src) {
        if (this.canMerge(src)) {
            this.levelAddition += src.levelAddition;
        }
    }

    public CompoundNBT serialize() {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74768_a("type", this.type.ordinal());
        cmp.func_74768_a("level", this.levelAddition);
        if (this.type.isEnchantmentSpecific()) {
            cmp.func_74778_a("ench", this.enchantment.getRegistryName().toString());
        }
        return cmp;
    }

    @Nullable
    public static AmuletEnchantment deserialize(CompoundNBT cmp) {
        int typeId = cmp.func_74762_e("type");
        DynamicEnchantmentType type = DynamicEnchantmentType.values()[typeId];
        int level = Math.max(0, cmp.func_74762_e("level"));
        if (type.isEnchantmentSpecific()) {
            ResourceLocation res = new ResourceLocation(cmp.func_74779_i("ench"));
            Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(res);
            if (e != null) {
                return new AmuletEnchantment(type, e, level);
            }
        } else {
            return new AmuletEnchantment(type, level);
        }
        return null;
    }
}

