/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity.goal;

import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectPelotrio;
import hellfirepvp.astralsorcery.common.entity.EntitySpectralTool;
import hellfirepvp.astralsorcery.common.entity.goal.SpectralToolGoal;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpectralToolBreakLogGoal
extends SpectralToolGoal {
    private BlockPos selectedBreakPos = null;

    public SpectralToolBreakLogGoal(EntitySpectralTool entity, double speed) {
        super(entity, speed);
    }

    private BlockPredicate breakableLogs() {
        return (world, pos, state) -> MiscUtils.getTileAt((IBlockReader)world, pos, TileEntity.class, false) == null && pos.func_177956_o() >= this.getEntity().getStartPosition().func_177956_o() && !state.isAir((IBlockReader)world, pos) && state.func_185887_b((IBlockReader)world, pos) != -1.0f && state.func_185887_b((IBlockReader)world, pos) <= 10.0f && (state.func_203425_a(BlockTags.field_200031_h) || state.func_203425_a(BlockTags.field_206952_E)) && BlockUtils.canToolBreakBlockWithoutPlayer(world, pos, state, new ItemStack((IItemProvider)Items.field_151056_x));
    }

    public boolean func_75250_a() {
        MovementController ctrl = this.getEntity().func_70605_aq();
        if (!ctrl.func_75640_a()) {
            return true;
        }
        BlockPos validPos = BlockDiscoverer.searchAreaForFirst(this.getEntity().func_130014_f_(), this.getEntity().getStartPosition(), 8, Vector3.atEntityCorner((Entity)this.getEntity()), this.breakableLogs());
        return validPos != null;
    }

    public boolean func_75253_b() {
        return this.selectedBreakPos != null;
    }

    public void func_75249_e() {
        super.func_75249_e();
        BlockPos validPos = BlockDiscoverer.searchAreaForFirst(this.getEntity().func_130014_f_(), this.getEntity().getStartPosition(), 10, Vector3.atEntityCorner((Entity)this.getEntity()), this.breakableLogs());
        if (validPos != null) {
            this.selectedBreakPos = validPos;
            this.getEntity().func_70605_aq().func_75642_a((double)this.selectedBreakPos.func_177958_n() + 0.5, (double)this.selectedBreakPos.func_177956_o() + 0.5, (double)this.selectedBreakPos.func_177952_p() + 0.5, this.getSpeed());
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.selectedBreakPos = null;
        this.actionCooldown = 0;
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (!this.func_75253_b()) {
            return;
        }
        if (this.actionCooldown < 0) {
            this.actionCooldown = 0;
        }
        World world = this.getEntity().func_130014_f_();
        boolean resetTimer = false;
        if (world.func_175623_d(this.selectedBreakPos)) {
            this.selectedBreakPos = null;
            resetTimer = true;
        } else {
            this.getEntity().func_70605_aq().func_75642_a((double)this.selectedBreakPos.func_177958_n() + 0.5, (double)this.selectedBreakPos.func_177956_o() + 0.5, (double)this.selectedBreakPos.func_177952_p() + 0.5, this.getSpeed());
            if (Vector3.atEntityCorner((Entity)this.getEntity()).distance((Vec3i)this.selectedBreakPos) <= 4.0) {
                ++this.actionCooldown;
                if (this.actionCooldown >= (Integer)MantleEffectPelotrio.CONFIG.ticksPerAxeLogBreak.get() && world instanceof ServerWorld) {
                    LivingEntity owner = this.getEntity().getOwningEntity();
                    if (owner instanceof PlayerEntity) {
                        BlockDropCaptureAssist.startCapturing();
                    }
                    if (BlockUtils.breakBlockWithoutPlayer((ServerWorld)world, this.selectedBreakPos, world.func_180495_p(this.selectedBreakPos), this.getEntity().getItem(), true, true, true)) {
                        resetTimer = true;
                    }
                    if (owner instanceof PlayerEntity) {
                        for (ItemStack dropped : BlockDropCaptureAssist.getCapturedStacksAndStop()) {
                            ItemStack remainder = ItemUtils.dropItemToPlayer((PlayerEntity)owner, dropped);
                            if (remainder.func_190926_b()) continue;
                            ItemUtils.dropItemNaturally(world, owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_(), remainder);
                        }
                    }
                }
            }
        }
        if (resetTimer) {
            this.actionCooldown = 0;
        }
    }
}

