/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity.technical;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityGrapplingHook
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static DataParameter<Integer> PULLING_ENTITY = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static DataParameter<Boolean> PULLING = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean launchedThrower = false;
    private int timeout = 0;
    private int previousDist = 0;
    public int despawning = -1;
    public float pullFactor = 0.0f;
    private LivingEntity throwingEntity;

    public EntityGrapplingHook(World world) {
        super(EntityTypesAS.GRAPPLING_HOOK, world);
    }

    public EntityGrapplingHook(LivingEntity thrower, World world) {
        super(EntityTypesAS.GRAPPLING_HOOK, thrower, world);
        float f = -MathHelper.func_76126_a((float)(thrower.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(thrower.field_70125_A * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(thrower.field_70125_A * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(thrower.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(thrower.field_70125_A * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, 1.7f, 0.0f);
        this.throwingEntity = thrower;
    }

    public static EntityType.IFactory<EntityGrapplingHook> factory() {
        return (spawnEntity, world) -> new EntityGrapplingHook(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PULLING, (Object)false);
        this.field_70180_af.func_187214_a(PULLING_ENTITY, (Object)-1);
    }

    public void setPulling(boolean pull, @Nullable LivingEntity hit) {
        this.field_70180_af.func_187227_b(PULLING, (Object)pull);
        this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)(hit == null ? -1 : hit.func_145782_y()));
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(PULLING);
    }

    @Nullable
    public LivingEntity getPulling() {
        int idPull = (Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY);
        if (idPull > 0) {
            try {
                return (LivingEntity)this.field_70170_p.func_73045_a(idPull);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public float despawnPercentage(float partial) {
        float p = (float)this.despawning - (1.0f - partial);
        return MathHelper.func_76131_a((float)(p /= 10.0f), (float)0.0f, (float)1.0f);
    }

    public boolean isDespawning() {
        return this.despawning != -1;
    }

    private void setDespawning() {
        if (this.despawning == -1) {
            this.despawning = 0;
        }
    }

    private void despawnTick() {
        ++this.despawning;
        if (this.despawning > 10) {
            this.func_70106_y();
        }
    }

    @Nullable
    public LivingEntity func_85052_h() {
        return this.throwingEntity != null ? this.throwingEntity : super.func_85052_h();
    }

    protected float func_70185_h() {
        return this.isPulling() ? 0.0f : 0.03f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_85052_h() == null || !this.func_85052_h().func_70089_S()) {
            this.setDespawning();
        }
        if (!this.isPulling() && this.field_70173_aa >= 30) {
            this.setDespawning();
        }
        if (this.field_70170_p.func_201670_d()) {
            this.pullFactor = !this.isPulling() ? (this.pullFactor += 0.02f) : (this.pullFactor *= 0.7f);
        }
        if (this.isDespawning()) {
            this.despawnTick();
            if (this.field_70170_p.func_201670_d() && this.despawning == 3) {
                this.playDespawnSparkles();
            }
        } else {
            LivingEntity thrower = this.func_85052_h();
            double dist = Math.max(0.01, (double)thrower.func_70032_d((Entity)this));
            if (this.func_70089_S() && this.isPulling()) {
                if (this.getPulling() != null) {
                    LivingEntity at = this.getPulling();
                    this.func_70107_b(at.func_226277_ct_(), at.func_226278_cu_(), at.func_226281_cx_());
                }
                if (this.getPulling() != null && this.field_70173_aa > 60 && dist < 2.0 || this.getPulling() == null && this.field_70173_aa > 15 && dist < 2.0 || this.timeout > 15) {
                    this.setDespawning();
                } else {
                    this.func_85052_h().field_70143_R = -5.0f;
                    double mx = this.func_226277_ct_() - this.func_85052_h().func_226277_ct_();
                    double my = this.func_226278_cu_() - this.func_85052_h().func_226278_cu_();
                    double mz = this.func_226281_cx_() - this.func_85052_h().func_226281_cx_();
                    Vec3d v2 = new Vec3d(mx /= dist * 5.0, my /= dist * 5.0, mz /= dist * 5.0);
                    if (v2.func_72433_c() > 0.25) {
                        v2 = v2.func_72432_b();
                        mx = v2.field_72450_a / 4.0;
                        my = v2.field_72448_b / 4.0;
                        mz = v2.field_72449_c / 4.0;
                    }
                    Vec3d motion = this.func_85052_h().func_213322_ci();
                    motion = motion.func_72441_c(mx, my + (double)0.04f, mz);
                    if (!this.launchedThrower) {
                        motion = motion.func_72441_c(0.0, (double)0.4f, 0.0);
                        this.launchedThrower = true;
                    }
                    this.func_85052_h().func_213317_d(motion);
                    int roughDst = (int)(dist / 2.5);
                    this.timeout = roughDst >= this.previousDist ? ++this.timeout : 0;
                    this.previousDist = roughDst;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playDespawnSparkles() {
        if (!this.isPulling()) {
            Vector3 ePos = RenderingVectorUtils.interpolatePosition((Entity)this, 1.0f);
            List<Vector3> positions = this.buildLine(1.0f);
            for (Vector3 pos : positions) {
                if (!this.field_70146_Z.nextBoolean()) continue;
                Vector3 motion = Vector3.random().multiply(0.005f);
                Vector3 at = pos.add(ePos);
                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setScaleMultiplier(0.3f + this.field_70146_Z.nextFloat() * 0.3f)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE))).setMotion(motion)).setMaxAge(25 + this.field_70146_Z.nextInt(20));
                if (!this.field_70146_Z.nextBoolean()) continue;
                p.color(VFXColorFunction.WHITE);
            }
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        int id = -1;
        if (this.throwingEntity != null) {
            id = this.throwingEntity.func_145782_y();
        }
        buffer.writeInt(id);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int id = additionalData.readInt();
        try {
            if (id > 0) {
                this.throwingEntity = (LivingEntity)this.field_70170_p.func_73045_a(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 64.0;
        if (Double.isNaN(d0)) {
            d0 = 64.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public AxisAlignedBB func_184177_bl() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public List<Vector3> buildLine(float partial) {
        if (this.func_85052_h() == null) {
            return Collections.emptyList();
        }
        LinkedList list = Lists.newLinkedList();
        Vector3 interpThrower = RenderingVectorUtils.interpolatePosition((Entity)this.func_85052_h(), partial);
        interpThrower.add(this.func_85052_h().func_213311_cf() / 2.0f, 0.0f, this.func_85052_h().func_213311_cf() / 2.0f);
        Vector3 interpHook = RenderingVectorUtils.interpolatePosition((Entity)this, partial);
        interpHook.add(this.func_213311_cf() / 2.0f, 0.0f, this.func_213311_cf() / 2.0f);
        Vector3 origin = new Vector3();
        Vector3 to = interpThrower.clone().subtract(interpHook).addY(this.func_85052_h().func_213302_cg() / 4.0f);
        float lineLength = (float)(to.length() * 5.0);
        list.add(origin.clone());
        int iter = (int)lineLength;
        for (int xx = 1; xx < iter - 1; ++xx) {
            float dist = (float)xx * (lineLength / (float)iter);
            double dx = (interpThrower.getX() - interpHook.getX()) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 10.0f)) * this.pullFactor);
            double dy = (interpThrower.getY() - interpHook.getY() + (double)(this.func_85052_h().func_213302_cg() / 2.0f)) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 7.0f)) * this.pullFactor);
            double dz = (interpThrower.getZ() - interpHook.getZ()) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 2.0f)) * this.pullFactor);
            list.add(new Vector3(dx, dy, dz));
        }
        list.add(to.clone());
        return list;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, 0.0f);
    }

    protected void func_70184_a(RayTraceResult result) {
        Vec3d hit = result.func_216347_e();
        switch (result.func_216346_c()) {
            case BLOCK: {
                this.setPulling(true, null);
                break;
            }
            case ENTITY: {
                Entity e = ((EntityRayTraceResult)result).func_216348_a();
                if (!(e instanceof LivingEntity) || this.func_85052_h() != null && e.equals((Object)this.func_85052_h())) {
                    return;
                }
                this.setPulling(true, (LivingEntity)((EntityRayTraceResult)result).func_216348_a());
                hit = new Vec3d(hit.field_72450_a, hit.field_72448_b + (double)(((EntityRayTraceResult)result).func_216348_a().func_213302_cg() * 3.0f / 4.0f), hit.field_72449_c);
                break;
            }
        }
        this.func_213293_j(0.0, 0.0, 0.0);
        this.func_70107_b(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

