/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event;

import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeTypeHelper;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AttributeEvent {
    private static final Field fAttributeMapEntity;

    public static double postProcessModded(PlayerEntity player, PerkAttributeType type, double value) {
        PostProcessModded ev = new PostProcessModded(value, type, player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static float postProcessModded(PlayerEntity player, PerkAttributeType type, float value) {
        return (float)AttributeEvent.postProcessModded(player, type, (double)value);
    }

    public static double postProcessModded(PlayerEntity player, ResourceLocation key, double value) {
        PerkAttributeType pType = (PerkAttributeType)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValue(key);
        if (pType == null) {
            return value;
        }
        return AttributeEvent.postProcessModded(player, pType, value);
    }

    public static float postProcessModded(PlayerEntity player, ResourceLocation key, float value) {
        return (float)AttributeEvent.postProcessModded(player, key, (double)value);
    }

    public static double postProcessVanilla(double value, ModifiableAttributeInstance attribute) {
        PostProcessVanilla event = new PostProcessVanilla(attribute, value);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getAttribute().func_111109_a(event.getValue());
    }

    @Nullable
    private static LivingEntity getEntity(AbstractAttributeMap map) {
        if (fAttributeMapEntity != null) {
            try {
                return (LivingEntity)fAttributeMapEntity.get(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setEntity(AbstractAttributeMap map, LivingEntity entity) {
        try {
            fAttributeMapEntity.set(map, entity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Field f = null;
        try {
            f = AbstractAttributeMap.class.getDeclaredField("as_entity");
        }
        catch (Exception exc) {
            f = null;
        }
        finally {
            fAttributeMapEntity = f;
        }
    }

    public static class PostProcessModded
    extends Event {
        private final PlayerEntity player;
        private final PerkAttributeType type;
        private final double originalValue;
        private double value;

        public PostProcessModded(double value, PerkAttributeType type, PlayerEntity player) {
            this.player = player;
            this.type = type;
            this.originalValue = value;
            this.value = value;
        }

        public double getOriginalValue() {
            return this.originalValue;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public PerkAttributeType getType() {
            return this.type;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }

    public static class PostProcessVanilla
    extends Event {
        private final ModifiableAttributeInstance instance;
        private final double originalValue;
        private double value;

        public PostProcessVanilla(ModifiableAttributeInstance instance, double value) {
            this.instance = instance;
            this.originalValue = value;
            this.value = value;
        }

        public double getOriginalValue() {
            return this.originalValue;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public ModifiableAttributeInstance getInstance() {
            return this.instance;
        }

        public IAttribute getAttribute() {
            return this.instance.func_111123_a();
        }

        @Nullable
        public PerkAttributeType resolveAttributeType() {
            return PerkAttributeTypeHelper.findVanillaType(this.getAttribute());
        }

        @Nullable
        public LivingEntity getEntityLiving() {
            return AttributeEvent.getEntity(this.getInstance().field_111138_a);
        }

        @Nullable
        public PlayerEntity getPlayer() {
            LivingEntity owner = this.getEntityLiving();
            if (owner instanceof PlayerEntity) {
                return (PlayerEntity)owner;
            }
            return null;
        }
    }
}

