/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.handler;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.GuiType;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.effect.EffectDropModifier;
import hellfirepvp.astralsorcery.common.item.ItemTome;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.lib.CapabilitiesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHandlerMisc {
    public static void attachListeners(IEventBus bus) {
        bus.addListener(EventHandlerMisc::onSpawnEffectCloud);
        bus.addListener(EventHandlerMisc::onPlayerSleepEclipse);
        bus.addListener(EventHandlerMisc::onChunkLoad);
        bus.addListener(EventHandlerMisc::onLecternOpen);
        bus.addListener(EventHandlerMisc::onCrystalToss);
    }

    private static void onCrystalToss(ItemTossEvent event) {
        ItemStack thrown;
        if (!event.getPlayer().func_130014_f_().func_201670_d() && (thrown = event.getEntityItem().func_92059_d()).func_77973_b() instanceof ItemCrystalBase) {
            event.getEntityItem().func_200216_c(event.getPlayer().func_110124_au());
        }
    }

    private static void onLecternOpen(PlayerInteractEvent.RightClickBlock event) {
        ItemStack contained;
        if (event.getWorld().func_201670_d()) {
            return;
        }
        LecternTileEntity lectern = MiscUtils.getTileAt((IBlockReader)event.getWorld(), event.getPos(), LecternTileEntity.class, false);
        if (lectern != null && (contained = lectern.func_214033_c()).func_77973_b() instanceof ItemTome) {
            event.setCanceled(true);
            AstralSorcery.getProxy().openGui(event.getPlayer(), GuiType.TOME, new Object[0]);
        }
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        IChunk ch = event.getChunk();
        if (ch instanceof Chunk && !event.getWorld().func_201670_d()) {
            ((Chunk)ch).getCapability(CapabilitiesAS.CHUNK_FLUID).ifPresent(entry -> {
                if (!entry.isInitialized()) {
                    IWorld w = event.getWorld();
                    long seed = w.func_72905_C();
                    long chX = event.getChunk().func_76632_l().field_77276_a;
                    long chZ = event.getChunk().func_76632_l().field_77275_b;
                    seed ^= chX << 32;
                    entry.generate(seed ^= chZ);
                    ((Chunk)ch).func_76630_e();
                }
            });
        }
    }

    private static void onPlayerSleepEclipse(PlayerSleepInBedEvent event) {
        WorldContext ctx = SkyHandler.getContext(event.getEntityLiving().func_130014_f_());
        if (ctx != null && ctx.getCelestialHandler().isSolarEclipseActive() && event.getResultStatus() == null) {
            event.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
    }

    private static void onSpawnEffectCloud(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AreaEffectCloudEntity && MiscUtils.contains(((AreaEffectCloudEntity)event.getEntity()).field_184503_f, effect -> effect.func_188419_a() instanceof EffectDropModifier)) {
            event.setCanceled(true);
        }
    }
}

