/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletRandomizeHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.item.base.client.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEnchantmentAmulet
extends Item
implements ItemDynamicColor {
    private static final Random rand = new Random();

    public ItemEnchantmentAmulet() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        List<AmuletEnchantment> enchantments = ItemEnchantmentAmulet.getAmuletEnchantments(stack);
        for (AmuletEnchantment ench : enchantments) {
            tooltip.add(new StringTextComponent(ench.getDisplay()).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
        }
        if (ItemEnchantmentAmulet.getAmuletColor(stack).map(color -> color == -1).orElse(false).booleanValue()) {
            tooltip.add(new TranslationTextComponent("astralsorcery.amulet.color.colorless", new Object[0]).func_211708_a(TextFormatting.ITALIC).func_211708_a(TextFormatting.GRAY));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.func_201670_d() && !ItemEnchantmentAmulet.getAmuletColor(stack).isPresent()) {
            ItemEnchantmentAmulet.freezeAmuletColor(stack);
        }
        if (!worldIn.func_201670_d() && ItemEnchantmentAmulet.getAmuletEnchantments(stack).isEmpty()) {
            AmuletRandomizeHelper.rollAmulet(stack);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return -1;
        }
        Optional<Integer> color = ItemEnchantmentAmulet.getAmuletColor(stack);
        if (color.isPresent()) {
            return color.get();
        }
        int tick = (int)(ClientScheduler.getClientTick() % 500000L);
        int c = Color.getHSBColor((float)tick / 500000.0f, 0.7f, 1.0f).getRGB();
        return c | 0xFF000000;
    }

    public static Optional<Integer> getAmuletColor(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return Optional.empty();
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("amuletColor")) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e("amuletColor"));
    }

    public static void freezeAmuletColor(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (tag.func_74764_b("amuletColor")) {
            return;
        }
        if (rand.nextInt(400) == 0) {
            tag.func_74768_a("amuletColor", -1);
        } else {
            tag.func_74768_a("amuletColor", Color.getHSBColor(rand.nextFloat(), 0.7f, 1.0f).getRGB() | 0xFF000000);
        }
    }

    public static List<AmuletEnchantment> getAmuletEnchantments(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return Lists.newArrayList();
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("amuletEnchantments")) {
            return Lists.newArrayList();
        }
        ListNBT enchants = tag.func_150295_c("amuletEnchantments", 10);
        ArrayList<AmuletEnchantment> enchantments = new ArrayList<AmuletEnchantment>(enchants.size());
        for (int i = 0; i < enchants.size(); ++i) {
            AmuletEnchantment ench = AmuletEnchantment.deserialize(enchants.func_150305_b(i));
            if (ench == null) continue;
            enchantments.add(ench);
        }
        enchantments.sort(Comparator.comparing(DynamicEnchantment::getType));
        return enchantments;
    }

    public static void setAmuletEnchantments(ItemStack stack, List<AmuletEnchantment> enchantments) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        enchantments.sort(Comparator.comparing(DynamicEnchantment::getType));
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        ListNBT enchants = new ListNBT();
        for (AmuletEnchantment enchant : enchantments) {
            enchants.add((Object)enchant.serialize());
        }
        tag.func_218657_a("amuletEnchantments", (INBT)enchants);
    }
}

