/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravedStarMap;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.MendingEnchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemInfusedGlass
extends Item {
    public ItemInfusedGlass() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(5).func_200916_a(CommonProxy.ITEM_GROUP_AS));
        this.func_185043_a(new ResourceLocation("engraved"), (stack, world, entity) -> ItemInfusedGlass.getEngraving(stack) != null ? 1.0f : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EngravedStarMap map = ItemInfusedGlass.getEngraving(stack);
        if (map != null) {
            for (ResourceLocation key : map.getConstellationKeys()) {
                IConstellation cst = ConstellationRegistry.getConstellation(key);
                if (cst == null) continue;
                String format = "item.astralsorcery.infused_glass.ttip";
                ITextComponent cstName = cst.getConstellationName().func_211708_a(TextFormatting.BLUE);
                if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                    String percent = String.valueOf(Math.round(map.getDistribution(cst) * 100.0f));
                    ITextComponent creativeHint = new TranslationTextComponent("item.astralsorcery.infused_glass.ttip.creative", new Object[]{percent}).func_211708_a(TextFormatting.LIGHT_PURPLE);
                    tooltip.add(new TranslationTextComponent(format, new Object[]{cstName, creativeHint}).func_211708_a(TextFormatting.GRAY));
                    continue;
                }
                tooltip.add(new TranslationTextComponent(format, new Object[]{cstName, ""}).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof MendingEnchantment) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || ItemInfusedGlass.getEngraving(stack) != null;
    }

    public String func_77667_c(ItemStack stack) {
        EngravedStarMap map = ItemInfusedGlass.getEngraving(stack);
        if (map != null) {
            return super.func_77667_c(stack) + ".active";
        }
        return super.func_77667_c(stack);
    }

    @Nullable
    public static EngravedStarMap getEngraving(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInfusedGlass)) {
            return null;
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (tag.func_150297_b("starmap", 10)) {
            return EngravedStarMap.deserialize(tag.func_74775_l("starmap"));
        }
        return null;
    }

    public static void setEngraving(@Nonnull ItemStack stack, @Nullable EngravedStarMap map) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInfusedGlass)) {
            return;
        }
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        if (map == null) {
            tag.func_82580_o("starmap");
        } else {
            tag.func_218657_a("starmap", (INBT)map.serialize());
        }
    }
}

