/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import hellfirepvp.astralsorcery.common.item.base.TypeEnchantableItem;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalTierItem;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ItemCrystalAxe
extends ItemCrystalTierItem
implements TypeEnchantableItem {
    private static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).build();

    public ItemCrystalAxe() {
        super(ToolType.AXE, new Item.Properties(), Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151584_j}));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            CrystalPropertiesAS.CREATIVE_CRYSTAL_TOOL_ATTRIBUTES.store(stack);
            stacks.add((Object)stack);
        }
    }

    @Override
    public boolean canEnchantItem(ItemStack stack, EnchantmentType type) {
        return type == EnchantmentType.BREAKABLE || type == EnchantmentType.DIGGER;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnchantmentType type = enchantment.field_77351_y;
        return type == EnchantmentType.ALL || type == EnchantmentType.DIGGER || type == EnchantmentType.BREAKABLE;
    }

    @Override
    double getAttackDamage() {
        return 11.0;
    }

    @Override
    double getAttackSpeed() {
        return -3.0;
    }

    @Override
    protected boolean isToolEfficientAgainst(BlockState state) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos blockpos;
        World world = ctx.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = ctx.func_195995_a());
        Block block = BLOCK_STRIPPING_MAP.get(blockstate.func_177230_c());
        if (block != null) {
            PlayerEntity playerentity = ctx.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.func_201670_d() && world.func_180501_a(blockpos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11) && playerentity != null) {
                ctx.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, e -> e.func_213334_d(ctx.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

