/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalPickaxe;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.lib.TagsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktOreScan;
import hellfirepvp.astralsorcery.common.perk.modifier.DynamicAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.provider.equipment.EquipmentAttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ItemInfusedCrystalPickaxe
extends ItemCrystalPickaxe
implements EquipmentAttributeModifierProvider {
    private static final DynamicAttributeModifier INFUSED_PICKAXE_MINING_SIZE = new DynamicAttributeModifier(UUID.fromString("ecf80c60-3da6-4952-90d0-5db5429ea44a"), PerkAttributeTypesAS.ATTR_TYPE_MINING_SIZE, ModifierType.ADDITION, 1.0f);

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (this.doOreScan(world, player.func_180425_c(), player, held)) {
            return ActionResult.func_226248_a_((Object)held);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && this.doOreScan(ctx.func_195991_k(), ctx.func_195995_a(), player, player.func_184586_b(ctx.func_221531_n()))) {
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(ctx);
    }

    private boolean doOreScan(World world, BlockPos origin, PlayerEntity player, ItemStack stack) {
        PlayerProgress prog;
        if (!world.func_201670_d() && player instanceof ServerPlayerEntity && !MiscUtils.isPlayerFakeMP((ServerPlayerEntity)player) && stack.func_77973_b() instanceof ItemInfusedCrystalPickaxe && !player.func_184811_cZ().func_185141_a(stack.func_77973_b()) && (prog = ResearchHelper.getProgress(player, LogicalSide.SERVER)).doPerkAbilities()) {
            List<BlockPos> orePositions = BlockDiscoverer.searchForBlocksAround(world, origin, 16, BlockPredicates.isInTag(TagsAS.Blocks.ORES));
            PacketChannel.CHANNEL.sendToPlayer(player, new PktOreScan(orePositions));
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 120);
            return true;
        }
        return false;
    }

    @Override
    public Collection<PerkAttributeModifier> getModifiers(ItemStack stack, PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        return Collections.singletonList(INFUSED_PICKAXE_MINING_SIZE);
    }
}

