/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.ore.BlockRockCrystalOre;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.data.world.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.item.base.OverrideInteractItem;
import hellfirepvp.astralsorcery.common.item.wand.WandInteractable;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.base.TileRequiresMultiblock;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.util.BlockArray;
import hellfirepvp.observerlib.client.preview.StructurePreview;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemWand
extends Item
implements OverrideInteractItem {
    public ItemWand() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        boolean active;
        boolean bl = active = isSelected || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184592_cb() == stack;
        if (!world.func_201670_d() && active && entity instanceof ServerPlayerEntity) {
            RockCrystalBuffer buf = (RockCrystalBuffer)DataAS.DOMAIN_AS.getData((IWorld)world, DataAS.KEY_ROCK_CRYSTAL_BUFFER);
            ChunkPos pos = new ChunkPos(entity.func_180425_c());
            for (BlockPos rPos : buf.collectPositions(pos, 4)) {
                PktPlayEffect pkt;
                BlockState state = world.func_180495_p(rPos);
                if (!(state.func_177230_c() instanceof BlockRockCrystalOre)) {
                    buf.removeOre(rPos);
                    continue;
                }
                if (!DayTimeHelper.isDay(world) && field_77697_d.nextInt(600) == 0) {
                    pkt = new PktPlayEffect(PktPlayEffect.Type.ROCK_CRYSTAL_COLUMN).addData(b -> ByteBufUtils.writeVector(b, new Vector3((Vec3i)rPos.func_177984_a())));
                    PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)entity, pkt);
                }
                if (field_77697_d.nextInt(800) != 0) continue;
                pkt = new PktPlayEffect(PktPlayEffect.Type.ROCK_CRYSTAL_SPARKS).addData(b -> ByteBufUtils.writeVector(b, new Vector3((Vec3i)rPos.func_177984_a())));
                PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)entity, pkt);
            }
        }
    }

    @Override
    public boolean shouldInterceptBlockInteract(LogicalSide side, PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        return true;
    }

    @Override
    public boolean doBlockInteract(LogicalSide side, PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        World world = player.func_130014_f_();
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof WandInteractable && ((WandInteractable)b).onInteract(world, pos, player, face, player.func_225608_bj_())) {
            return true;
        }
        WandInteractable wandTe = MiscUtils.getTileAt((IBlockReader)world, pos, WandInteractable.class, true);
        if (wandTe != null && wandTe.onInteract(world, pos, player, face, player.func_225608_bj_())) {
            return true;
        }
        TileRequiresMultiblock mbTe = MiscUtils.getTileAt((IBlockReader)world, pos, TileRequiresMultiblock.class, true);
        if (mbTe != null && mbTe.getRequiredStructureType() != null && mbTe.getRequiredStructureType().getStructure() instanceof MatchableStructure && !((MatchableStructure)mbTe.getRequiredStructureType().getStructure()).matches((IBlockReader)world, pos)) {
            if (world.func_201670_d()) {
                this.displayClientStructurePreview(world, pos, mbTe.getRequiredStructureType());
            } else if (player.func_213453_ef() && player.func_184812_l_()) {
                BlockArray structure = mbTe.getRequiredStructureType().getStructure();
                structure.getContents().forEach((offset, rState) -> world.func_175656_a(pos.func_177971_a((Vec3i)offset), rState.getDescriptiveState(0L)));
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void displayClientStructurePreview(World world, BlockPos pos, StructureType type) {
        StructurePreview.newBuilder((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos, (MatchableStructure)((MatchableStructure)type.getStructure())).removeIfOutInDifferentWorld().andPersistOnlyIf((inWorld, at) -> MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
            TileRequiresMultiblock tileFound = MiscUtils.getTileAt((IBlockReader)world, pos, TileRequiresMultiblock.class, true);
            if (tileFound == null) {
                return false;
            }
            return tileFound.getRequiredStructureType() != null && tileFound.getRequiredStructureType().equals(type);
        }, true)).andPersistOnlyIf((inWorld, at) -> !((MatchableStructure)type.getStructure()).matches((IBlockReader)world, pos)).showBar(type.getDisplayName()).buildAndSet();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playUndergroundEffect(PktPlayEffect effect) {
        Vector3 at = ByteBufUtils.readVector(effect.getExtraData());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        float dstr = 0.4f + 0.6f * DayTimeHelper.getCurrentDaytimeDistribution((World)world);
        Vector3 plVec = Vector3.atEntityCorner((Entity)Minecraft.func_71410_x().field_71439_g);
        float dst = (float)at.distance(plVec);
        float dstMul = dst <= 25.0f ? 1.0f : (dst >= 50.0f ? 0.0f : 1.0f - (dst - 25.0f) / 25.0f);
        for (int i = 0; i < 3; ++i) {
            if (!field_77697_d.nextBoolean()) continue;
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_DEPTH_PARTICLE).spawn(at.clone().add(-1.0f + field_77697_d.nextFloat() * 3.0f, -1.0f + field_77697_d.nextFloat() * 3.0f, -1.0f + field_77697_d.nextFloat() * 3.0f))).color(VFXColorFunction.constant(ColorsAS.ROCK_CRYSTAL))).setScaleMultiplier(0.4f)).setAlphaMultiplier(150.0f * dstr / 255.0f * dstMul)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(30 + field_77697_d.nextInt(10));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playEffect(PktPlayEffect effect) {
        Vector3 pos = ByteBufUtils.readVector(effect.getExtraData());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        BlockPos at = pos.toBlockPos();
        BlockPos top = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, at);
        Vector3 columnDisplay = new Vector3((Vec3i)top);
        MiscUtils.applyRandomOffset(columnDisplay, field_77697_d, 2.0f);
        double mX = field_77697_d.nextFloat() * 0.01f * (float)(field_77697_d.nextBoolean() ? 1 : -1);
        double mY = field_77697_d.nextFloat() * 0.5f;
        double mZ = field_77697_d.nextFloat() * 0.01f * (float)(field_77697_d.nextBoolean() ? 1 : -1);
        float dstr = DayTimeHelper.getCurrentDaytimeDistribution((World)world);
        for (int i = 0; i < 8 + field_77697_d.nextInt(10); ++i) {
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(columnDisplay)).setMotion(new Vector3(mX * (0.2 + 0.8 * (double)field_77697_d.nextFloat()), mY * (double)field_77697_d.nextFloat(), mZ * (0.2 + 0.8 * (double)field_77697_d.nextFloat())))).color(VFXColorFunction.constant(ColorsAS.ROCK_CRYSTAL))).setAlphaMultiplier(150.0f * dstr / 255.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.3f + 0.3f * field_77697_d.nextFloat())).setMaxAge(25 + field_77697_d.nextInt(30));
        }
    }
}

