/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktToggleClientOption
extends ASPacket<PktToggleClientOption> {
    private Option option;

    public PktToggleClientOption() {
    }

    public PktToggleClientOption(Option option) {
        this.option = option;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktToggleClientOption> encoder() {
        return (pkt, buf) -> ByteBufUtils.writeEnumValue(buf, pkt.option);
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktToggleClientOption> decoder() {
        return buf -> new PktToggleClientOption(ByteBufUtils.readEnumValue(buf, Option.class));
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktToggleClientOption> handler() {
        return new ASPacket.Handler<PktToggleClientOption>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktToggleClientOption packet, NetworkEvent.Context context) {
            }

            @Override
            public void handleServer(PktToggleClientOption packet, NetworkEvent.Context context) {
                ServerPlayerEntity player = context.getSender();
                switch (packet.option) {
                    case DISABLE_PERK_ABILITIES: {
                        PlayerProgress prog;
                        if (!ResearchManager.togglePerkAbilities((PlayerEntity)player) || !(prog = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.SERVER)).isValid()) break;
                        ITextComponent status = prog.doPerkAbilities() ? new TranslationTextComponent("astralsorcery.progress.perk_abilities.enable", new Object[0]).func_211708_a(TextFormatting.GREEN) : new TranslationTextComponent("astralsorcery.progress.perk_abilities.disable", new Object[0]).func_211708_a(TextFormatting.RED);
                        player.func_145747_a(new TranslationTextComponent("astralsorcery.progress.perk_abilities", new Object[]{status}).func_211708_a(TextFormatting.GRAY));
                    }
                }
            }

            @Override
            public void handle(PktToggleClientOption packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }

    public static enum Option {
        DISABLE_PERK_ABILITIES;

    }
}

