/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPerkTree;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.ASRegistryEvents;
import hellfirepvp.astralsorcery.common.perk.AllocationStatus;
import hellfirepvp.astralsorcery.common.perk.PerkCooldownHelper;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.perk.source.ModifierManager;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.util.CacheEventBus;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class AbstractPerk
implements ModifierSource {
    protected static final Random rand = new Random();
    public static final PerkCategory CATEGORY_BASE = new PerkCategory("base", TextFormatting.WHITE);
    public static final PerkCategory CATEGORY_ROOT = new PerkCategory("root", TextFormatting.WHITE);
    public static final PerkCategory CATEGORY_MAJOR = new PerkCategory("major", TextFormatting.WHITE);
    public static final PerkCategory CATEGORY_KEY = new PerkCategory("key", TextFormatting.GOLD);
    public static final PerkCategory CATEGORY_EPIPHANY = new PerkCategory("epiphany", TextFormatting.GOLD);
    public static final PerkCategory CATEGORY_FOCUS = new PerkCategory("focus", TextFormatting.GOLD);
    private final ResourceLocation registryName;
    private final CacheEventBus busWrapper;
    protected final Point2D.Float offset;
    private String unlocalizedKey;
    private PerkCategory category = CATEGORY_BASE;
    private PerkTreePoint<? extends AbstractPerk> treePoint = null;
    private ResourceLocation customPerkType = null;
    private List<ITextComponent> tooltipCache = null;
    private boolean cacheTooltip = true;
    private float cacheEffectMultiplier = 1.0f;

    public AbstractPerk(ResourceLocation name, float x, float y) {
        this.registryName = name;
        this.busWrapper = CacheEventBus.of(MinecraftForge.EVENT_BUS);
        this.offset = new Point2D.Float(x, y);
        this.unlocalizedKey = String.format("perk.%s.%s", name.func_110624_b(), name.func_110623_a());
    }

    protected PerkTreePoint<? extends AbstractPerk> initPerkTreePoint() {
        return new PerkTreePoint<AbstractPerk>(this, this.getOffset());
    }

    protected void invalidate(LogicalSide side) {
        this.busWrapper.unregisterAll();
        PerkCooldownHelper.removePerkCooldowns(side, this);
    }

    protected void validate(LogicalSide side) {
        this.attachListeners(side, this.busWrapper);
    }

    protected void attachListeners(LogicalSide side, IEventBus bus) {
    }

    @Nonnull
    public Point2D.Float getOffset() {
        return this.offset;
    }

    public final PerkTreePoint<? extends AbstractPerk> getPoint() {
        if (this.treePoint == null) {
            this.treePoint = this.initPerkTreePoint();
        }
        return this.treePoint;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public <T> T setCategory(PerkCategory category) {
        this.category = category;
        return (T)this;
    }

    protected void applyEffectMultiplier(float multiplier) {
        this.cacheEffectMultiplier = multiplier;
    }

    protected int applyMultiplierI(double val) {
        return MathHelper.func_76128_c((double)(val * (double)this.cacheEffectMultiplier));
    }

    protected double applyMultiplierD(double val) {
        return val * (double)this.cacheEffectMultiplier;
    }

    public boolean modifiersDisabled(PlayerEntity player, LogicalSide dist) {
        ASRegistryEvents.PerkDisable event = new ASRegistryEvents.PerkDisable(this, player, dist);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isPerkDisabled();
    }

    @Override
    public boolean canApplySource(PlayerEntity player, LogicalSide dist) {
        return !ResearchHelper.getProgress(player, dist).isPerkSealed(this);
    }

    @Override
    public final void onApply(PlayerEntity player, LogicalSide dist) {
        if (this.modifiersDisabled(player, dist)) {
            return;
        }
        this.applyPerkLogic(player, dist);
    }

    @Override
    public final void onRemove(PlayerEntity player, LogicalSide dist) {
        if (this.modifiersDisabled(player, dist)) {
            return;
        }
        this.removePerkLogic(player, dist);
    }

    protected void applyPerkLogic(PlayerEntity player, LogicalSide dist) {
    }

    protected void removePerkLogic(PlayerEntity player, LogicalSide dist) {
    }

    protected LogicalSide getSide(Entity entity) {
        return entity.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    @Nullable
    public CompoundNBT getPerkData(PlayerEntity player, LogicalSide dist) {
        return ResearchHelper.getProgress(player, dist).getPerkData(this);
    }

    public void modifyPerkServer(PlayerEntity player, PlayerProgress progress, CompoundNBT dataStorage) {
    }

    public void onUnlockPerkServer(@Nullable PlayerEntity player, PlayerProgress progress, CompoundNBT dataStorage) {
    }

    public void onRemovePerkServer(PlayerEntity player, PlayerProgress progress, CompoundNBT dataStorage) {
    }

    public <T extends AbstractPerk> T setName(String name) {
        this.unlocalizedKey = name;
        return (T)this;
    }

    @Nonnull
    public PerkCategory getCategory() {
        return this.category;
    }

    public AllocationStatus getPerkStatus(@Nullable PlayerEntity player, LogicalSide side) {
        if (player == null) {
            return AllocationStatus.UNALLOCATED;
        }
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        if (!progress.isValid()) {
            return AllocationStatus.UNALLOCATED;
        }
        if (progress.hasPerkUnlocked(this)) {
            return AllocationStatus.ALLOCATED;
        }
        return this.mayUnlockPerk(progress, player) ? AllocationStatus.UNLOCKABLE : AllocationStatus.UNALLOCATED;
    }

    public boolean mayUnlockPerk(PlayerProgress progress, PlayerEntity player) {
        if (!progress.hasFreeAllocationPoint(player, this.getSide((Entity)player))) {
            return false;
        }
        for (AbstractPerk otherPerks : PerkTree.PERK_TREE.getConnectedPerks(this.getSide((Entity)player), this)) {
            if (!progress.hasPerkUnlocked(otherPerks)) continue;
            return true;
        }
        return false;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent(this.unlocalizedKey + ".name", new Object[0]).func_211708_a(this.getCategory().getTextFormatting());
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Collection<ITextComponent> getDescription() {
        ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
        if (I18n.func_188566_a((String)(this.unlocalizedKey + ".desc.1"))) {
            int count = 1;
            while (I18n.func_188566_a((String)(this.unlocalizedKey + ".desc." + count))) {
                toolTip.add((ITextComponent)new TranslationTextComponent(this.unlocalizedKey + ".desc." + count, new Object[0]));
                ++count;
            }
            toolTip.add((ITextComponent)new StringTextComponent(""));
        } else if (I18n.func_188566_a((String)(this.unlocalizedKey + ".desc"))) {
            toolTip.add((ITextComponent)new TranslationTextComponent(this.unlocalizedKey + ".desc", new Object[0]));
            toolTip.add((ITextComponent)new StringTextComponent(""));
        }
        return toolTip;
    }

    protected void disableTooltipCaching() {
        this.cacheTooltip = false;
        this.tooltipCache = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final Collection<ITextComponent> getLocalizedTooltip() {
        if (this.cacheTooltip && this.tooltipCache != null) {
            return this.tooltipCache;
        }
        this.tooltipCache = Lists.newArrayList();
        if (this.modifiersDisabled((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT)) {
            this.tooltipCache.add(new TranslationTextComponent("perk.info.astralsorcery.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        } else if (!(this instanceof ProgressGatedPerk) || ((ProgressGatedPerk)this).canSeeClient()) {
            this.tooltipCache.add(this.getName());
            int prevLength = this.tooltipCache.size();
            boolean shouldAdd = this.addLocalizedTooltip(this.tooltipCache);
            if (shouldAdd && prevLength != this.tooltipCache.size()) {
                this.tooltipCache.add((ITextComponent)new StringTextComponent(""));
            }
            this.tooltipCache.addAll(this.getDescription());
        } else {
            this.tooltipCache.add(new TranslationTextComponent("perk.info.astralsorcery.missing_progress", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        return this.tooltipCache;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addLocalizedTooltip(Collection<ITextComponent> tooltip) {
        return false;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Collection<ITextComponent> getSource() {
        String modid = this.getRegistryName().func_110624_b();
        ModContainer mod = ModList.get().getModContainerById(modid).orElse(null);
        if (mod != null) {
            return Lists.newArrayList((Iterable)new StringTextComponent(mod.getModInfo().getDisplayName()));
        }
        return null;
    }

    public void clearCaches(LogicalSide side) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clearClientTextCaches() {
        this.tooltipCache = null;
    }

    @Override
    public ResourceLocation getProviderName() {
        return ModifierManager.PERK_PROVIDER_KEY;
    }

    @Override
    public boolean isEqual(ModifierSource other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPerk)) {
            return false;
        }
        AbstractPerk that = (AbstractPerk)o;
        return Objects.equals(this.getRegistryName(), that.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean handleMouseClick(ScreenJournalPerkTree gui, double mouseX, double mouseY) {
        return false;
    }

    public void deserializeData(JsonObject perkData) {
    }

    public void serializeData(JsonObject perkData) {
    }

    @Nullable
    public final ResourceLocation getCustomPerkType() {
        return this.customPerkType;
    }

    public final void setCustomPerkType(ResourceLocation customPerkType) {
        this.customPerkType = customPerkType;
    }

    public final JsonObject serializePerk() {
        JsonObject data = new JsonObject();
        data.addProperty("registry_name", this.getRegistryName().toString());
        if (this.getCustomPerkType() != null) {
            data.addProperty("perk_class", this.getCustomPerkType().toString());
        }
        data.addProperty("x", (Number)Float.valueOf(this.getOffset().x));
        data.addProperty("y", (Number)Float.valueOf(this.getOffset().y));
        data.addProperty("name", this.unlocalizedKey);
        JsonObject perkData = new JsonObject();
        this.serializeData(perkData);
        data.add("data", (JsonElement)perkData);
        return data;
    }

    public static class PerkCategory {
        private final String unlocName;
        private final TextFormatting color;

        public PerkCategory(@Nonnull String unlocName, @Nonnull TextFormatting color) {
            this.unlocName = unlocName;
            this.color = color;
        }

        public TextFormatting getTextFormatting() {
            return this.color;
        }

        public String getUnlocalizedName() {
            return "perk.category.astralsorcery." + this.unlocName + ".name";
        }

        @OnlyIn(value=Dist.CLIENT)
        public String getLocalizedName() {
            return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerkCategory that = (PerkCategory)o;
            return Objects.equals(this.unlocName, that.unlocName);
        }

        public int hashCode() {
            return Objects.hash(this.unlocName);
        }
    }
}

