/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.perk.modifier.DynamicAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.AttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.source.provider.equipment.EquipmentAttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class DynamicModifierHelper {
    public static final String KEY_MODIFIERS = "attribute_modifiers";

    public static void addModifier(ItemStack stack, UUID uuid, PerkAttributeType type, ModifierType mode, float value) {
        DynamicModifierHelper.addModifier(stack, new DynamicAttributeModifier(uuid, type, mode, value));
    }

    public static void addModifier(ItemStack stack, DynamicAttributeModifier modifier) {
        DynamicModifierHelper.addModifiers(stack, Collections.singletonList(modifier));
    }

    public static void addModifiers(ItemStack stack, Iterable<DynamicAttributeModifier> modifiers) {
        CompoundNBT tag = NBTHelper.getPersistentData(stack);
        ListNBT modifierList = tag.func_150295_c(KEY_MODIFIERS, 10);
        modifiers.forEach(modifier -> modifierList.add((Object)modifier.serialize()));
        tag.func_218657_a(KEY_MODIFIERS, (INBT)modifierList);
    }

    public static List<PerkAttributeModifier> getDynamicModifiers(ItemStack stack, PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        ArrayList modifiers = Lists.newArrayList();
        if (stack.func_77973_b() instanceof AttributeModifierProvider) {
            modifiers.addAll(((AttributeModifierProvider)stack.func_77973_b()).getModifiers(player, side, ignoreRequirements));
        }
        if (stack.func_77973_b() instanceof EquipmentAttributeModifierProvider) {
            modifiers.addAll(((EquipmentAttributeModifierProvider)stack.func_77973_b()).getModifiers(stack.func_77946_l(), player, side, ignoreRequirements));
        }
        modifiers.addAll(DynamicModifierHelper.getStaticModifiers(stack));
        return modifiers;
    }

    public static List<DynamicAttributeModifier> getStaticModifiers(ItemStack stack) {
        ArrayList modifiers = Lists.newArrayList();
        if (NBTHelper.hasPersistentData(stack)) {
            CompoundNBT tag = NBTHelper.getPersistentData(stack);
            ListNBT modifierList = tag.func_150295_c(KEY_MODIFIERS, 10);
            for (int i = 0; i < modifierList.size(); ++i) {
                CompoundNBT modifierTag = modifierList.func_150305_b(i);
                modifiers.add(DynamicAttributeModifier.deserialize(modifierTag));
            }
        }
        return modifiers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addModifierTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return;
        }
        for (PerkAttributeModifier mod : DynamicModifierHelper.getDynamicModifiers(stack, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT, false)) {
            if (!mod.hasDisplayString()) continue;
            tooltip.add(new StringTextComponent(mod.getLocalizedDisplayString()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        }
    }
}

