/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.data.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;

public abstract class PerkDataProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public PerkDataProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public abstract void registerPerks(Consumer<FinishedPerk> var1);

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet builtPerks = new HashSet();
        this.registerPerks(finishedPerk -> {
            ResourceLocation perkName = ((FinishedPerk)finishedPerk).perk.getRegistryName();
            Point2D.Float offset = ((FinishedPerk)finishedPerk).perk.getOffset();
            if (builtPerks.stream().anyMatch(knownPerk -> ((FinishedPerk)knownPerk).perk.getOffset().equals(offset))) {
                throw new IllegalArgumentException("Duplicate perk registration at " + offset + " for " + perkName);
            }
            if (!builtPerks.add(finishedPerk)) {
                throw new IllegalArgumentException("Duplicate perk registry name: " + perkName);
            }
            this.savePerkFile(cache, (JsonElement)((FinishedPerk)finishedPerk).serialize(), path.resolve(String.format("data/%s/perks/%s.json", perkName.func_110624_b(), perkName.func_110623_a())));
        });
        JsonObject allPerks = new JsonObject();
        builtPerks.forEach(perk -> allPerks.add(((FinishedPerk)perk).perk.getRegistryName().toString(), (JsonElement)((FinishedPerk)perk).serialize()));
        this.savePerkFile(cache, (JsonElement)allPerks, path.resolve("data/astralsorcery/perks/_full_tree.json"));
    }

    private void savePerkFile(DirectoryCache cache, JsonElement perk, Path filePath) {
        try {
            String perkJson = GSON.toJson(perk);
            String perkHash = field_208307_a.hashUnencodedChars((CharSequence)perkJson).toString();
            if (!Objects.equals(cache.func_208323_a(filePath), perkHash) || !Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                    bufferedwriter.write(perkJson);
                }
            }
            cache.func_208316_a(filePath, perkHash);
        }
        catch (IOException exc) {
            AstralSorcery.log.error("Couldn't save perk {}", (Object)filePath, (Object)exc);
        }
    }

    public String func_200397_b() {
        return "Perks";
    }

    public static class FinishedPerk {
        private final AbstractPerk perk;
        private final List<ResourceLocation> connections;

        public FinishedPerk(AbstractPerk perk, List<ResourceLocation> connections) {
            this.perk = perk;
            this.connections = connections;
        }

        private JsonObject serialize() {
            JsonObject object = this.perk.serializePerk();
            JsonArray array = new JsonArray();
            for (ResourceLocation connection : this.connections) {
                array.add(connection.toString());
            }
            object.add("connection", (JsonElement)array);
            return object;
        }
    }
}

