/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.modifier;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PerkAttributeModifier
extends ForgeRegistryEntry<PerkAttributeModifier> {
    private static long counter = 0L;
    protected ResourceLocation comparisonKey;
    protected final ModifierType mode;
    protected final PerkAttributeType attributeType;
    protected float value;
    private boolean absolute = false;
    protected double ctMultiplier = 1.0;
    private Map<PerkConverter, Table<PerkAttributeType, ModifierType, PerkAttributeModifier>> cachedConverters = Maps.newHashMap();

    public PerkAttributeModifier(PerkAttributeType type, ModifierType mode, float value) {
        this.comparisonKey = AstralSorcery.key("generic_perk_modifier_" + counter++);
        this.attributeType = type;
        this.mode = mode;
        this.value = value;
        this.initModifier();
    }

    public PerkAttributeModifier(ResourceLocation persistentKey, PerkAttributeType type, ModifierType mode, float value) {
        this.comparisonKey = persistentKey;
        this.attributeType = type;
        this.mode = mode;
        this.value = value;
        this.setRegistryName(persistentKey);
        this.initModifier();
    }

    public ResourceLocation getComparisonKey() {
        return this.comparisonKey;
    }

    protected void initModifier() {
    }

    protected void setAbsolute() {
        this.absolute = true;
    }

    void multiplyValue(double multiplier) {
        this.ctMultiplier = multiplier;
        this.value = this.mode == ModifierType.STACKING_MULTIPLY ? (this.value - 1.0f) * (float)multiplier + 1.0f : (float)((double)this.value * multiplier);
    }

    @Nonnull
    public PerkAttributeModifier convertModifier(PerkAttributeType type, ModifierType mode, float value) {
        if (this.absolute) {
            return this;
        }
        PerkAttributeModifier mod = this.createModifier(type, mode, value);
        mod.comparisonKey = this.comparisonKey;
        return mod;
    }

    @Nonnull
    public PerkAttributeModifier gainAsExtraModifier(PerkConverter converter, PerkAttributeType type, ModifierType mode, float value) {
        PerkAttributeModifier modifier = this.getCachedAttributeModifier(converter, type, mode);
        if (modifier == null) {
            modifier = this.createModifier(type, mode, value);
            modifier.setAbsolute();
            this.addModifierToCache(converter, type, mode, modifier);
        }
        return modifier;
    }

    @Nullable
    protected PerkAttributeModifier getCachedAttributeModifier(PerkConverter converter, PerkAttributeType type, ModifierType mode) {
        Table cachedModifiers = this.cachedConverters.computeIfAbsent(converter, c -> HashBasedTable.create());
        return (PerkAttributeModifier)((Object)cachedModifiers.get((Object)type, (Object)mode));
    }

    protected void addModifierToCache(PerkConverter converter, PerkAttributeType type, ModifierType mode, PerkAttributeModifier modifier) {
        Table cachedModifiers = this.cachedConverters.computeIfAbsent(converter, c -> HashBasedTable.create());
        cachedModifiers.put((Object)type, (Object)mode, (Object)modifier);
    }

    @Nonnull
    protected PerkAttributeModifier createModifier(PerkAttributeType type, ModifierType mode, float value) {
        return type.createModifier(value, mode);
    }

    @Deprecated
    public final float getRawValue() {
        return this.value;
    }

    public float getValue(PlayerEntity player, PlayerProgress progress) {
        return this.getRawValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getValueForDisplay(PlayerEntity player, PlayerProgress progress) {
        return this.getValue(player, progress);
    }

    public ModifierType getMode() {
        return this.mode;
    }

    public PerkAttributeType getAttributeType() {
        return this.attributeType;
    }

    protected String getUnlocalizedAttributeName() {
        return this.getAttributeType().getUnlocalizedName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasDisplayString() {
        return I18n.func_188566_a((String)this.getAttributeType().getUnlocalizedName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedAttributeValue() {
        return this.getMode().stringifyValue(this.getValueForDisplay((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ResearchHelper.getClientProgress()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedModifierName() {
        return I18n.func_135052_a((String)this.getMode().getUnlocalizedModifierName(this.getValueForDisplay((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ResearchHelper.getClientProgress())), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getAttributeDisplayFormat() {
        return I18n.func_135052_a((String)"perk.modifier.astralsorcery.format", (Object[])new Object[0]);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedDisplayString() {
        if (!this.hasDisplayString()) {
            return null;
        }
        return String.format(this.getAttributeDisplayFormat(), this.getLocalizedAttributeValue(), this.getLocalizedModifierName(), I18n.func_135052_a((String)this.getUnlocalizedAttributeName(), (Object[])new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PerkAttributeModifier that = (PerkAttributeModifier)((Object)o);
        return this.comparisonKey.equals((Object)that.comparisonKey);
    }

    public int hashCode() {
        return Objects.hashCode(this.comparisonKey);
    }
}

