/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.perk.CooldownPerk;
import hellfirepvp.astralsorcery.common.perk.PerkCooldownHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyCheatDeath
extends KeyPerk
implements CooldownPerk {
    private static final int defaultCooldownPotionApplication = 600;
    private static final int defaultPotionDuration = 500;
    private static final int defaultPotionAmplifier = 0;
    private static final int defaultChargeCost = 350;
    public static final Config CONFIG = new Config("key.cheat_death");

    public KeyCheatDeath(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.HIGHEST, this::onDeath);
    }

    private void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            LogicalSide side = this.getSide((Entity)player);
            PlayerProgress progress = ResearchHelper.getProgress(player, side);
            if (side.isServer() && progress.hasPerkEffect(this) && !PerkCooldownHelper.isCooldownActiveForPlayer(player, this) && AlignmentChargeHandler.INSTANCE.drainCharge(player, side, ((Integer)CONFIG.chargeCost.get()).intValue(), false)) {
                PerkCooldownHelper.setCooldownActiveForPlayer(player, this, this.applyMultiplierI(((Integer)CONFIG.cooldownPotionApplication.get()).intValue()));
                player.func_195064_c(new EffectInstance((Effect)EffectsAS.EFFECT_CHEAT_DEATH, this.applyMultiplierI(((Integer)CONFIG.potionDuration.get()).intValue()), this.applyMultiplierI(((Integer)CONFIG.potionAmplifier.get()).intValue()), true, false, true));
            }
        }
    }

    @Override
    public void onCooldownTimeout(PlayerEntity player) {
    }

    private static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue cooldownPotionApplication;
        private ForgeConfigSpec.IntValue potionDuration;
        private ForgeConfigSpec.IntValue potionAmplifier;
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.cooldownPotionApplication = cfgBuilder.comment("Once the potion effect gets applied, it'll take at least this amount of ticks or a server restart until it can be re-applied by this perk.").translation(this.translationKey("cooldownPotionApplication")).defineInRange("cooldownPotionApplication", 600, 1, Integer.MAX_VALUE);
            this.potionDuration = cfgBuilder.comment("Once the potion effect gets applied by any of the triggers, this will be used as tick-duration of the potion effect.").translation(this.translationKey("potionDuration")).defineInRange("potionDuration", 500, 1, Integer.MAX_VALUE);
            this.potionAmplifier = cfgBuilder.comment("Once the potion effect gets applied by any of the triggers, this will be used as amplifier of the potion effect.").translation(this.translationKey("potionAmplifier")).defineInRange("potionAmplifier", 0, 0, 4);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per death-prevention.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 350, 1, 500);
        }
    }
}

