/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyDigTypes
extends KeyPerk {
    public KeyDigTypes(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(this::onHarvest);
        bus.addListener(this::onHarvestSpeed);
    }

    private void onHarvest(PlayerEvent.HarvestCheck event) {
        ToolType requiredTool;
        ItemStack heldMainHand;
        LogicalSide side;
        if (event.canHarvest()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerProgress prog = ResearchHelper.getProgress(player, side = this.getSide((Entity)player));
        if (prog.hasPerkEffect(this) && !(heldMainHand = player.func_184614_ca()).func_190926_b() && heldMainHand.func_77973_b().getToolTypes(heldMainHand).contains(ToolType.PICKAXE) && ((requiredTool = event.getTargetBlock().getHarvestTool()) == null || requiredTool.equals(ToolType.SHOVEL) || requiredTool.equals(ToolType.AXE))) {
            event.setCanHarvest(true);
        }
    }

    private void onHarvestSpeed(PlayerEvent.BreakSpeed event) {
        LogicalSide side;
        PlayerEntity player = event.getPlayer();
        PlayerProgress prog = ResearchHelper.getProgress(player, side = this.getSide((Entity)player));
        if (prog.hasPerkEffect(this)) {
            BlockState broken = event.getState();
            ItemStack playerMainHand = player.func_184614_ca();
            if (!playerMainHand.func_190926_b() && playerMainHand.func_77973_b().getToolTypes(playerMainHand).contains(ToolType.PICKAXE) && !broken.isToolEffective(ToolType.PICKAXE) && (broken.isToolEffective(ToolType.AXE) || broken.isToolEffective(ToolType.SHOVEL))) {
                EventFlags.CHECK_BREAK_SPEED.executeWithFlag(() -> MiscUtils.tryMultiple(() -> Float.valueOf(player.getDigSpeed(Blocks.field_150348_b.func_176223_P(), event.getPos())), () -> Float.valueOf(player.getDigSpeed(Blocks.field_150348_b.func_176223_P(), null)), () -> Float.valueOf(BlockUtils.getSimpleBreakSpeed((LivingEntity)player, playerMainHand, Blocks.field_150348_b.func_176223_P()))).ifPresent(speed -> event.setNewSpeed(Math.max(event.getNewSpeed(), speed.floatValue()))));
            }
        }
    }
}

