/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyDisarm
extends KeyPerk {
    private static final float defaultDropChance = 0.05f;
    public static final Config CONFIG = new Config("key.disarm");

    public KeyDisarm(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.HIGH, this::onAttack);
    }

    private void onAttack(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).hasPerkEffect(this)) {
            float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, (float)this.applyMultiplierD((Double)CONFIG.dropChance.get()));
            float currentChance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                LivingEntity attacked;
                ItemStack stack;
                if (rand.nextFloat() >= currentChance || (stack = (attacked = event.getEntityLiving()).func_184582_a(slot)).func_190926_b()) continue;
                attacked.func_184201_a(slot, ItemStack.field_190927_a);
                ItemUtils.dropItemNaturally(attacked.field_70170_p, attacked.func_226277_ct_(), attacked.func_226278_cu_(), attacked.func_226281_cx_(), stack);
                break;
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue dropChance;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.dropChance = cfgBuilder.comment("Defines the chance (in percent) per hit to make the attacked entity drop its armor.").translation(this.translationKey("dropChance")).defineInRange("dropChance", (double)0.05f, 0.0, 1.0);
        }
    }
}

