/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyNoArmor
extends KeyPerk {
    private static final float defaultDamageTakenMultiplier = 0.7f;
    public static final Config CONFIG = new Config("key.no_armor");

    public KeyNoArmor(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(this::onLivingHurt);
    }

    private void onLivingHurt(LivingHurtEvent event) {
        LogicalSide side;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        PlayerProgress prog = ResearchHelper.getProgress(player, side = this.getSide((Entity)player));
        if (prog.hasPerkEffect(this)) {
            int eq = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                ++eq;
            }
            if (eq < 2) {
                float multiplier = (float)this.applyMultiplierD((Double)CONFIG.damageTakenMultiplier.get());
                float effMulti = PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
                event.setAmount(event.getAmount() * (multiplier * (1.0f / effMulti)));
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue damageTakenMultiplier;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.damageTakenMultiplier = cfgBuilder.comment("The multiplier that is applied to damage the player receives. The lower the more damage is negated.").translation(this.translationKey("damageTakenMultiplier")).defineInRange("damageTakenMultiplier", (double)0.7f, (double)0.1f, 1.0);
        }
    }
}

