/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyProjectileProximity
extends KeyPerk {
    private static final float defaultCapDistance = 100.0f;
    private static final float defaultMaxAdditionalMultiplier = 0.75f;
    public static final Config CONFIG = new Config("key.proj_proximity");

    public KeyProjectileProximity(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.HIGH, this::onProjDamage);
    }

    private void onProjDamage(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        DamageSource source;
        if (event.getSource().func_76352_a() && (source = event.getSource()).func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).hasPerkEffect(this)) {
            float added = (float)this.applyMultiplierD((Double)CONFIG.maxAdditionalMultiplier.get());
            added *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
            float capDstSq = ((Double)CONFIG.capDistance.get()).floatValue();
            float dst = -((float)player.func_70068_e((Entity)event.getEntityLiving()) - capDstSq);
            if ((dst /= capDstSq) < 0.0f) {
                dst /= 10.0f;
            }
            dst = Math.max(0.0f, 1.0f + dst);
            float amt = event.getAmount();
            event.setAmount(amt *= Math.max(0.0f, added *= dst));
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue capDistance;
        private ForgeConfigSpec.DoubleValue maxAdditionalMultiplier;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.capDistance = cfgBuilder.comment("Defines the distance at which no additional damage is awarded.").translation(this.translationKey("capDistance")).defineInRange("capDistance", 100.0, 4.0, 65536.0);
            this.maxAdditionalMultiplier = cfgBuilder.comment("Defines the maximum multiplier that can be reached if the distance when hitting something with projectiles is basically nothing.").translation(this.translationKey("maxAdditionalMultiplier")).defineInRange("maxAdditionalMultiplier", 0.75, (double)0.05f, 5.0);
        }
    }
}

