/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.source.provider.equipment;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.ModifierManager;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSourceProvider;
import hellfirepvp.astralsorcery.common.perk.source.provider.equipment.EquipmentModifierSource;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class EquipmentSourceProvider
extends ModifierSourceProvider<EquipmentModifierSource> {
    static final String KEY_MOD_IDENTIFIER = "modifier_identifier";

    public EquipmentSourceProvider() {
        super(ModifierManager.EQUIPMENT_PROVIDER_KEY);
    }

    @Override
    protected void update(ServerPlayerEntity playerEntity) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot == EquipmentSlotType.OFFHAND) continue;
            ResourceLocation id = AstralSorcery.key("slot_" + slot.func_188450_d());
            ItemStack stack = playerEntity.func_184582_a(slot);
            EquipmentModifierSource slotSource = new EquipmentModifierSource(slot, stack.func_77946_l());
            if (!stack.func_190926_b()) {
                Collection<PerkAttributeModifier> modifiers = slotSource.getModifiers((PlayerEntity)playerEntity, LogicalSide.SERVER, false);
                if (!modifiers.isEmpty()) {
                    CompoundNBT nbt = NBTHelper.getPersistentData(stack);
                    if (!nbt.func_186855_b(KEY_MOD_IDENTIFIER)) {
                        nbt.func_186854_a(KEY_MOD_IDENTIFIER, UUID.randomUUID());
                    }
                    this.updateSource(playerEntity, id, slotSource);
                    continue;
                }
                this.updateSource(playerEntity, id, null);
                continue;
            }
            this.updateSource(playerEntity, id, null);
        }
    }

    @Override
    public void serialize(EquipmentModifierSource source, PacketBuffer buf) {
        ByteBufUtils.writeEnumValue(buf, source.slot);
        ByteBufUtils.writeItemStack(buf, source.itemStack);
    }

    @Override
    public EquipmentModifierSource deserialize(PacketBuffer buf) {
        EquipmentSlotType type = ByteBufUtils.readEnumValue(buf, EquipmentSlotType.class);
        ItemStack stack = ByteBufUtils.readItemStack(buf);
        return new EquipmentModifierSource(type, stack);
    }
}

