/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeMiningSize
extends PerkAttributeType {
    public static final Config CONFIG = new Config("type." + PerkAttributeTypesAS.KEY_ATTR_TYPE_MINING_SIZE.func_110623_a());

    public AttributeTypeMiningSize() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_MINING_SIZE);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(this::onBreak);
    }

    private void onBreak(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (!(world instanceof World) || world.func_201670_d()) {
            return;
        }
        if (player instanceof ServerPlayerEntity) {
            PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
            if (!prog.doPerkAbilities() || MiscUtils.isPlayerFakeMP((ServerPlayerEntity)player)) {
                return;
            }
            EventFlags.MINING_SIZE_BREAK.executeWithFlag(() -> {
                BlockRayTraceResult brtr;
                float size = PerkAttributeHelper.getOrCreateMap(player, LogicalSide.SERVER).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_MINING_SIZE, 0.0f);
                if ((size = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_MINING_SIZE, size)) >= 1.0f && (brtr = MiscUtils.rayTraceLookBlock(player, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE)) != null && brtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    int levelBroken = event.getState().getHarvestLevel();
                    float hardnessBroken = event.getState().func_185903_a(player, (IBlockReader)world, event.getPos());
                    BlockPredicate miningTest = (world1, pos, state) -> state.getHarvestLevel() <= levelBroken && state.func_185903_a(player, (IBlockReader)world1, pos) <= hardnessBroken;
                    Direction dir = brtr.func_216354_b();
                    if (dir.func_176740_k() == Direction.Axis.Y) {
                        this.breakBlocksPlaneHorizontal((ServerPlayerEntity)player, dir, (World)world, event.getPos(), miningTest, MathHelper.func_76141_d((float)size));
                    } else {
                        this.breakBlocksPlaneVertical((ServerPlayerEntity)player, dir, (World)world, event.getPos(), miningTest, MathHelper.func_76141_d((float)size));
                    }
                }
            });
        }
    }

    private void breakBlocksPlaneVertical(ServerPlayerEntity player, Direction sideBroken, World world, BlockPos at, BlockPredicate mineCheck, int size) {
        if (size <= 0) {
            return;
        }
        for (int xx = -size; xx <= size; ++xx) {
            if (sideBroken.func_176730_m().func_177958_n() != 0 && xx != 0) continue;
            for (int yy = -1; yy <= size * 2 - 1; ++yy) {
                if (sideBroken.func_176730_m().func_177956_o() != 0 && yy != 0) continue;
                for (int zz = -size; zz <= size; ++zz) {
                    BlockPos other;
                    BlockState otherState;
                    if (sideBroken.func_176730_m().func_177952_p() != 0 && zz != 0 || (otherState = world.func_180495_p(other = at.func_177982_a(xx, yy, zz))).func_185887_b((IBlockReader)world, other) == -1.0f || !player.func_184812_l_() && !mineCheck.test(world, other, otherState) || !AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true) || BlockUtils.isFluidBlock(otherState) || !player.field_71134_c.func_180237_b(other)) continue;
                    AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
                }
            }
        }
    }

    private void breakBlocksPlaneHorizontal(ServerPlayerEntity player, Direction sideBroken, World world, BlockPos at, BlockPredicate mineCheck, int size) {
        if (size <= 0) {
            return;
        }
        for (int xx = -size; xx <= size; ++xx) {
            if (sideBroken.func_176730_m().func_177958_n() != 0 && xx != 0) continue;
            for (int zz = -size; zz <= size; ++zz) {
                BlockPos other;
                BlockState otherState;
                if (sideBroken.func_176730_m().func_177952_p() != 0 && zz != 0 || (otherState = world.func_180495_p(other = at.func_177982_a(xx, 0, zz))).func_185887_b((IBlockReader)world, other) == -1.0f || !player.func_184812_l_() && !mineCheck.test(world, other, otherState) || !AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true) || BlockUtils.isFluidBlock(otherState) || !player.field_71134_c.func_180237_b(other)) continue;
                AlignmentChargeHandler.INSTANCE.drainCharge((PlayerEntity)player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
            }
        }
    }

    private static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per additional block break through this attribute.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 4, 1, 500);
        }
    }
}

