/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PerkAttributeType
extends ForgeRegistryEntry<PerkAttributeType> {
    protected static final Random rand = new Random();
    private Map<LogicalSide, Set<UUID>> applicationCache = Maps.newHashMap();
    private final boolean isOnlyMultiplicative;

    protected PerkAttributeType(ResourceLocation key) {
        this(key, false);
    }

    protected PerkAttributeType(ResourceLocation key, boolean isMultiplicative) {
        this.setRegistryName(key);
        this.isOnlyMultiplicative = isMultiplicative;
        this.init();
        this.attachListeners(MinecraftForge.EVENT_BUS);
    }

    public static PerkAttributeType makeDefault(ResourceLocation name, boolean isMultiplicative) {
        return new PerkAttributeType(name, isMultiplicative);
    }

    public boolean isMultiplicative() {
        return this.isOnlyMultiplicative;
    }

    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    public String getUnlocalizedName() {
        return String.format("perk.attribute.%s.%s.name", this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a());
    }

    protected void init() {
    }

    protected void attachListeners(IEventBus eventBus) {
    }

    protected LogicalSide getSide(Entity entity) {
        return entity.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    @Nullable
    public PerkAttributeReader getReader() {
        return (PerkAttributeReader)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_READERS.getValue(this.getRegistryName());
    }

    @Nonnull
    public PerkAttributeModifier createModifier(float modifier, ModifierType mode) {
        if (this.isMultiplicative() && mode == ModifierType.ADDITION) {
            throw new IllegalArgumentException("Tried creating addition-modifier for a multiplicative-only modifier!");
        }
        return new PerkAttributeModifier(this, mode, modifier);
    }

    public void onApply(PlayerEntity player, LogicalSide side, ModifierSource source) {
        Set applied = this.applicationCache.computeIfAbsent(side, s -> new HashSet());
        applied.add(player.func_110124_au());
    }

    public void onRemove(PlayerEntity player, LogicalSide side, boolean removedCompletely, ModifierSource source) {
        if (removedCompletely) {
            this.applicationCache.computeIfAbsent(side, s -> new HashSet()).remove(player.func_110124_au());
        }
    }

    public void onModeApply(PlayerEntity player, ModifierType mode, LogicalSide side) {
    }

    public void onModeRemove(PlayerEntity player, ModifierType mode, LogicalSide side, boolean removedCompletely) {
    }

    public boolean hasTypeApplied(PlayerEntity player, LogicalSide side) {
        return this.applicationCache.computeIfAbsent(side, s -> new HashSet()).contains(player.func_110124_au());
    }

    private void clear(LogicalSide side) {
        this.applicationCache.remove(side);
    }

    public static void clearCache(LogicalSide side) {
        for (PerkAttributeType type : RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES) {
            type.clear(side);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PerkAttributeType that = (PerkAttributeType)((Object)o);
        return Objects.equals(this.getRegistryName(), that.getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }
}

