/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlockProperties;
import hellfirepvp.astralsorcery.common.item.ItemAquamarine;
import hellfirepvp.astralsorcery.common.item.ItemChisel;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.item.ItemGlassLens;
import hellfirepvp.astralsorcery.common.item.ItemHandTelescope;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.item.ItemKnowledgeShare;
import hellfirepvp.astralsorcery.common.item.ItemLinkingTool;
import hellfirepvp.astralsorcery.common.item.ItemParchment;
import hellfirepvp.astralsorcery.common.item.ItemResonatingGem;
import hellfirepvp.astralsorcery.common.item.ItemResonator;
import hellfirepvp.astralsorcery.common.item.ItemStardust;
import hellfirepvp.astralsorcery.common.item.ItemStarmetalIngot;
import hellfirepvp.astralsorcery.common.item.ItemTome;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.item.base.client.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedRockCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemRockCrystal;
import hellfirepvp.astralsorcery.common.item.dust.ItemIlluminationPowder;
import hellfirepvp.astralsorcery.common.item.dust.ItemNocturnalPowder;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGemDay;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGemNight;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGemSky;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensBreak;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensDamage;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensFire;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensGrowth;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensPush;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensRegeneration;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensSpectral;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalAxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalPickaxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalShovel;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalSword;
import hellfirepvp.astralsorcery.common.item.tool.ItemInfusedCrystalAxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemInfusedCrystalPickaxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemInfusedCrystalShovel;
import hellfirepvp.astralsorcery.common.item.tool.ItemInfusedCrystalSword;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStar;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStarAevitas;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStarArmara;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStarDiscidia;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStarEvorsio;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStarVicio;
import hellfirepvp.astralsorcery.common.item.wand.ItemArchitectWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemBlinkWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemExchangeWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemGrappleWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemWand;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryBlocks;
import hellfirepvp.astralsorcery.common.registry.RegistryFluids;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import hellfirepvp.astralsorcery.common.util.dispenser.FluidContainerDispenseBehavior;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;

public class RegistryItems {
    private static final List<ItemDynamicColor> colorItems = Lists.newArrayList();

    private RegistryItems() {
    }

    public static void registerItems() {
        ItemsAS.AQUAMARINE = RegistryItems.registerItem(new ItemAquamarine());
        ItemsAS.RESONATING_GEM = RegistryItems.registerItem(new ItemResonatingGem());
        ItemsAS.GLASS_LENS = RegistryItems.registerItem(new ItemGlassLens());
        ItemsAS.PARCHMENT = RegistryItems.registerItem(new ItemParchment());
        ItemsAS.STARMETAL_INGOT = RegistryItems.registerItem(new ItemStarmetalIngot());
        ItemsAS.STARDUST = RegistryItems.registerItem(new ItemStardust());
        ItemsAS.PERK_GEM_SKY = RegistryItems.registerItem(new ItemPerkGemSky());
        ItemsAS.PERK_GEM_DAY = RegistryItems.registerItem(new ItemPerkGemDay());
        ItemsAS.PERK_GEM_NIGHT = RegistryItems.registerItem(new ItemPerkGemNight());
        ItemsAS.CRYSTAL_AXE = RegistryItems.registerItem(new ItemCrystalAxe());
        ItemsAS.CRYSTAL_PICKAXE = RegistryItems.registerItem(new ItemCrystalPickaxe());
        ItemsAS.CRYSTAL_SHOVEL = RegistryItems.registerItem(new ItemCrystalShovel());
        ItemsAS.CRYSTAL_SWORD = RegistryItems.registerItem(new ItemCrystalSword());
        ItemsAS.INFUSED_CRYSTAL_AXE = RegistryItems.registerItem(new ItemInfusedCrystalAxe());
        ItemsAS.INFUSED_CRYSTAL_PICKAXE = RegistryItems.registerItem(new ItemInfusedCrystalPickaxe());
        ItemsAS.INFUSED_CRYSTAL_SHOVEL = RegistryItems.registerItem(new ItemInfusedCrystalShovel());
        ItemsAS.INFUSED_CRYSTAL_SWORD = RegistryItems.registerItem(new ItemInfusedCrystalSword());
        ItemsAS.TOME = RegistryItems.registerItem(new ItemTome());
        ItemsAS.CONSTELLATION_PAPER = RegistryItems.registerItem(new ItemConstellationPaper());
        ItemsAS.ENCHANTMENT_AMULET = RegistryItems.registerItem(new ItemEnchantmentAmulet());
        ItemsAS.KNOWLEDGE_SHARE = RegistryItems.registerItem(new ItemKnowledgeShare());
        ItemsAS.WAND = RegistryItems.registerItem(new ItemWand());
        ItemsAS.CHISEL = RegistryItems.registerItem(new ItemChisel());
        ItemsAS.RESONATOR = RegistryItems.registerItem(new ItemResonator());
        ItemsAS.LINKING_TOOL = RegistryItems.registerItem(new ItemLinkingTool());
        ItemsAS.ILLUMINATION_WAND = RegistryItems.registerItem(new ItemIlluminationWand());
        ItemsAS.ARCHITECT_WAND = RegistryItems.registerItem(new ItemArchitectWand());
        ItemsAS.EXCHANGE_WAND = RegistryItems.registerItem(new ItemExchangeWand());
        ItemsAS.GRAPPLE_WAND = RegistryItems.registerItem(new ItemGrappleWand());
        ItemsAS.BLINK_WAND = RegistryItems.registerItem(new ItemBlinkWand());
        ItemsAS.HAND_TELESCOPE = RegistryItems.registerItem(new ItemHandTelescope());
        ItemsAS.INFUSED_GLASS = RegistryItems.registerItem(new ItemInfusedGlass());
        ItemsAS.MANTLE = RegistryItems.registerItem(new ItemMantle());
        ItemsAS.PERK_SEAL = RegistryItems.registerItem(new ItemPerkSeal());
        ItemsAS.NOCTURNAL_POWDER = RegistryItems.registerItem(new ItemNocturnalPowder());
        ItemsAS.ILLUMINATION_POWDER = RegistryItems.registerItem(new ItemIlluminationPowder());
        ItemsAS.SHIFTING_STAR = RegistryItems.registerItem(new ItemShiftingStar());
        ItemsAS.SHIFTING_STAR_AEVITAS = RegistryItems.registerItem(new ItemShiftingStarAevitas());
        ItemsAS.SHIFTING_STAR_ARMARA = RegistryItems.registerItem(new ItemShiftingStarArmara());
        ItemsAS.SHIFTING_STAR_DISCIDIA = RegistryItems.registerItem(new ItemShiftingStarDiscidia());
        ItemsAS.SHIFTING_STAR_EVORSIO = RegistryItems.registerItem(new ItemShiftingStarEvorsio());
        ItemsAS.SHIFTING_STAR_VICIO = RegistryItems.registerItem(new ItemShiftingStarVicio());
        ItemsAS.COLORED_LENS_FIRE = RegistryItems.registerItem(new ItemColoredLensFire());
        ItemsAS.COLORED_LENS_BREAK = RegistryItems.registerItem(new ItemColoredLensBreak());
        ItemsAS.COLORED_LENS_GROWTH = RegistryItems.registerItem(new ItemColoredLensGrowth());
        ItemsAS.COLORED_LENS_DAMAGE = RegistryItems.registerItem(new ItemColoredLensDamage());
        ItemsAS.COLORED_LENS_REGENERATION = RegistryItems.registerItem(new ItemColoredLensRegeneration());
        ItemsAS.COLORED_LENS_PUSH = RegistryItems.registerItem(new ItemColoredLensPush());
        ItemsAS.COLORED_LENS_SPECTRAL = RegistryItems.registerItem(new ItemColoredLensSpectral());
        ItemsAS.ROCK_CRYSTAL = RegistryItems.registerItem(new ItemRockCrystal());
        ItemsAS.ATTUNED_ROCK_CRYSTAL = RegistryItems.registerItem(new ItemAttunedRockCrystal());
        ItemsAS.CELESTIAL_CRYSTAL = RegistryItems.registerItem(new ItemCelestialCrystal());
        ItemsAS.ATTUNED_CELESTIAL_CRYSTAL = RegistryItems.registerItem(new ItemAttunedCelestialCrystal());
    }

    public static void registerItemBlocks() {
        RegistryBlocks.ITEM_BLOCKS.forEach(RegistryItems::registerItemBlock);
    }

    public static void registerFluidContainerItems() {
        RegistryFluids.FLUID_HOLDER_ITEMS.forEach(RegistryItems::registerItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerColors(ColorHandlerEvent.Item itemColorEvent) {
        colorItems.forEach(item -> itemColorEvent.getItemColors().func_199877_a(item::getColor, new IItemProvider[]{(Item)item}));
    }

    public static void registerDispenseBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)ItemsAS.BUCKET_LIQUID_STARLIGHT, (IDispenseItemBehavior)FluidContainerDispenseBehavior.getInstance());
    }

    private static void registerItemBlock(CustomItemBlock block) {
        BlockItem itemBlock = block.createItemBlock(RegistryItems.buildItemBlockProperties((Block)block));
        itemBlock.setRegistryName(itemBlock.func_179223_d().getRegistryName());
        AstralSorcery.getProxy().getRegistryPrimer().register(itemBlock);
    }

    private static <T extends Item> T registerItem(T item) {
        ResourceLocation name = NameUtil.fromClass(item, "Item");
        item.setRegistryName(name);
        AstralSorcery.getProxy().getRegistryPrimer().register(item);
        if (item instanceof ItemDynamicColor) {
            colorItems.add((ItemDynamicColor)item);
        }
        return item;
    }

    private static Item.Properties buildItemBlockProperties(Block block) {
        Item.Properties props = new Item.Properties();
        props.func_200916_a(CommonProxy.ITEM_GROUP_AS);
        if (block instanceof CustomItemBlockProperties) {
            ItemGroup group = ((CustomItemBlockProperties)block).getItemGroup();
            if (group != null) {
                props.func_200916_a(group);
            }
            if (!((CustomItemBlockProperties)block).canItemBeRepaired()) {
                props.setNoRepair();
            }
            props.func_208103_a(((CustomItemBlockProperties)block).getItemRarity());
            props.func_200917_a(((CustomItemBlockProperties)block).getItemMaxStackSize());
            props.func_200915_b(((CustomItemBlockProperties)block).getItemMaxDamage());
            props.func_200919_a(((CustomItemBlockProperties)block).getContainerItem());
            props.setISTER(((CustomItemBlockProperties)block).getItemTEISR());
            ((CustomItemBlockProperties)block).getItemToolLevels().forEach((arg_0, arg_1) -> ((Item.Properties)props).addToolType(arg_0, arg_1));
        }
        return props;
    }
}

