/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.lib.PerkCustomModifiersAS;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.LogicalSide;

public class RegistryPerkCustomModifiers {
    private RegistryPerkCustomModifiers() {
    }

    public static void init() {
        PerkCustomModifiersAS.FOCUS_GELU = RegistryPerkCustomModifiers.register(new PerkAttributeModifier(AstralSorcery.key("focus_gelu"), PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ModifierType.ADDED_MULTIPLY, 0.02f){

            @Override
            protected void initModifier() {
                super.initModifier();
                this.setAbsolute();
            }

            @Override
            public float getValue(PlayerEntity player, PlayerProgress progress) {
                return this.getRawValue() * (float)(progress.getAppliedPerks().size() - progress.getSealedPerks().size());
            }

            @Override
            public boolean hasDisplayString() {
                return false;
            }
        });
        PerkCustomModifiersAS.FOCUS_ULTERIA = RegistryPerkCustomModifiers.register(new PerkAttributeModifier(AstralSorcery.key("focus_ulteria"), PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, ModifierType.STACKING_MULTIPLY, 1.05f){

            @Override
            protected void initModifier() {
                super.initModifier();
                this.setAbsolute();
            }

            @Override
            public float getValue(PlayerEntity player, PlayerProgress progress) {
                LogicalSide side = player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
                return 1.0f + 0.05f * (float)progress.getAvailablePerkPoints(player, side);
            }

            @Override
            public boolean hasDisplayString() {
                return false;
            }
        });
        PerkCustomModifiersAS.FOCUS_VORUX = RegistryPerkCustomModifiers.register(new PerkAttributeModifier(AstralSorcery.key("focus_vorux"), PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ModifierType.ADDED_MULTIPLY, 0.01f){

            @Override
            protected void initModifier() {
                super.initModifier();
                this.setAbsolute();
            }

            @Override
            public float getValue(PlayerEntity player, PlayerProgress progress) {
                return this.getRawValue() * (float)(progress.getAppliedPerks().size() - progress.getSealedPerks().size());
            }

            @Override
            public boolean hasDisplayString() {
                return false;
            }
        });
    }

    private static <T extends PerkAttributeModifier> T register(T modifier) {
        AstralSorcery.getProxy().getRegistryPrimer().register(modifier);
        return modifier;
    }
}

