/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry.internal;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InternalRegistryPrimer {
    private Map<Class<?>, List<IForgeRegistryEntry<?>>> primed = new HashMap();

    public <V extends IForgeRegistryEntry<V>> V register(V entry) {
        Class type = entry.getRegistryType();
        List entries = this.primed.computeIfAbsent(type, k -> Lists.newLinkedList());
        entries.add(entry);
        return entry;
    }

    <T extends IForgeRegistryEntry<T>> List<?> getEntries(Class<T> type) {
        return this.primed.getOrDefault(type, Collections.emptyList());
    }

    @Nullable
    public <V extends IForgeRegistryEntry<V>> V getCached(IForgeRegistry<V> registry, ResourceLocation key) {
        return (V)MiscUtils.iterativeSearch(this.primed.getOrDefault(registry.getRegistrySuperType(), Collections.emptyList()), entry -> entry.getRegistryName().equals((Object)key));
    }
}

