/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;

public class StarlightUpdateHandler
implements ITickHandler {
    private static final StarlightUpdateHandler instance = new StarlightUpdateHandler();
    private static Map<DimensionType, List<IPrismTransmissionNode>> updateRequired = new HashMap<DimensionType, List<IPrismTransmissionNode>>();
    private static final Object accessLock = new Object();

    private StarlightUpdateHandler() {
    }

    public static StarlightUpdateHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.func_201670_d()) {
            return;
        }
        List<IPrismTransmissionNode> nodes = this.getNodes((IWorld)world);
        Object object = accessLock;
        synchronized (object) {
            for (IPrismTransmissionNode node : nodes) {
                node.update(world);
            }
        }
    }

    private List<IPrismTransmissionNode> getNodes(IWorld world) {
        DimensionType dimType = world.func_201675_m().func_186058_p();
        return updateRequired.computeIfAbsent(dimType, k -> new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(IWorld world, IPrismTransmissionNode node) {
        Object object = accessLock;
        synchronized (object) {
            this.getNodes(world).remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(IWorld world, IPrismTransmissionNode node) {
        Object object = accessLock;
        synchronized (object) {
            this.getNodes(world).add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informWorldLoad(IWorld world) {
        Object object = accessLock;
        synchronized (object) {
            updateRequired.remove(world.func_201675_m().func_186058_p());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearServer() {
        Object object = accessLock;
        synchronized (object) {
            updateRequired.clear();
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Starlight Update Handler";
    }
}

