/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.ore.BlockStarmetalOre;
import hellfirepvp.astralsorcery.common.block.tile.BlockCelestialCrystalCluster;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeTile;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCelestialCrystals
extends TileEntityTick
implements CrystalAttributeTile {
    public static final int TICK_GROWTH_CHANCE = 18000;
    private CrystalAttributes attributes = null;

    public TileCelestialCrystals() {
        super(TileEntityTypesAS.CELESTIAL_CRYSTAL_CLUSTER);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            if (this.getGrowth() < 4 && this.doesSeeSky()) {
                this.tryGrowWithChance(18000);
            }
        } else {
            BlockState downState = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b());
            if (downState.func_177230_c() instanceof BlockStarmetalOre) {
                this.playStarmetalParticles();
            }
            if (this.getGrowth() == 4) {
                this.playFullyGrownParticles();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStarmetalParticles() {
        if (rand.nextInt(9) == 0) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).add(0.1, 0.0, 0.1).add((double)rand.nextFloat() * 0.8, 0.0, (double)rand.nextFloat() * 0.8))).color(VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE))).setMotion(new Vector3(0.0, 0.02 + (double)(rand.nextFloat() * 0.05f), 0.0))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.15f);
        }
        if (rand.nextInt(4) == 0) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).addY(0.05).add(rand.nextFloat(), 0.0f, rand.nextFloat()))).color(VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.06f + rand.nextFloat() * 0.05f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playFullyGrownParticles() {
        if (rand.nextInt(4) == 0) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(this).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()))).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.1f + rand.nextFloat() * 0.15f);
        }
    }

    public void tryGrowWithChance(int growthChance) {
        BlockState downState = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b());
        if (downState.func_177230_c() instanceof BlockStarmetalOre) {
            growthChance = (int)((double)growthChance * 0.6);
            if (rand.nextInt(400) == 0) {
                this.func_145831_w().func_175656_a(this.func_174877_v().func_177977_b(), Blocks.field_150366_p.func_176223_P());
            }
        }
        float distribution = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
        growthChance = (int)((float)growthChance * (1.0f - 0.5f * distribution));
        this.grow(growthChance);
    }

    public void grow(int chance) {
        int stage;
        if (rand.nextInt(Math.max(chance, 1)) == 0 && (stage = this.getGrowth()) < 4) {
            this.setGrowth(stage + 1);
        }
    }

    public int getGrowth() {
        BlockState current = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (Integer)current.func_177229_b((IProperty)BlockCelestialCrystalCluster.STAGE);
    }

    public void setGrowth(int stage) {
        BlockState next = (BlockState)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER.func_176223_P().func_206870_a((IProperty)BlockCelestialCrystalCluster.STAGE, (Comparable)Integer.valueOf(stage));
        this.func_145831_w().func_175656_a(this.func_174877_v(), next);
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        if (this.attributes != null) {
            this.attributes.store(compound);
        } else {
            CrystalAttributes.storeNull(compound);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.attributes = CrystalAttributes.getCrystalAttributes(compound);
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nullable CrystalAttributes attributes) {
        this.attributes = attributes;
    }
}

