/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXColorEffectSphere;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.event.effect.GatewayUIRenderHandler;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.DataAS;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.tile.base.TileOwned;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PlayerReference;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.INameable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCelestialGateway
extends TileEntityTick
implements INameable,
TileOwned,
LinkableTileEntity {
    private static final BlockPos[] OFFSETS_ALLOWED_PREVIEW = new BlockPos[]{new BlockPos(-3, 0, -2), new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 0), new BlockPos(-3, 0, 1), new BlockPos(-3, 0, 2), new BlockPos(-2, 0, 3), new BlockPos(-1, 0, 3), new BlockPos(0, 0, 3), new BlockPos(1, 0, 3), new BlockPos(2, 0, 3), new BlockPos(3, 0, 2), new BlockPos(3, 0, 1), new BlockPos(3, 0, 0), new BlockPos(3, 0, -1), new BlockPos(3, 0, -2), new BlockPos(2, 0, -3), new BlockPos(1, 0, -3), new BlockPos(0, 0, -3), new BlockPos(-1, 0, -3), new BlockPos(-2, 0, -3)};
    private boolean networkRegistered = false;
    private ITextComponent displayText = null;
    private DyeColor color = null;
    private boolean locked = false;
    private PlayerReference owner = null;
    private Map<Integer, PlayerReference> allowedUsers = new HashMap<Integer, PlayerReference>();
    private Object clientGatewaySphereEffect = null;

    public TileCelestialGateway() {
        super(TileEntityTypesAS.GATEWAY);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            this.playEffects();
        } else {
            boolean complete = this.hasMultiblock() & this.doesSeeSky();
            if (complete) {
                GatewayCache cache;
                if (!this.networkRegistered && (cache = (GatewayCache)DataAS.DOMAIN_AS.getData((IWorld)this.field_145850_b, DataAS.KEY_GATEWAY_CACHE)).offerPosition(this.field_145850_b, this.func_174877_v())) {
                    cache.updateGatewayNode(this.func_174877_v(), node -> {
                        node.setDisplayName(this.displayText);
                        node.setColor(this.color);
                    });
                    this.updateAccessInformation();
                    this.networkRegistered = true;
                    this.markForUpdate();
                }
            } else if (this.networkRegistered) {
                ((GatewayCache)DataAS.DOMAIN_AS.getData((IWorld)this.field_145850_b, DataAS.KEY_GATEWAY_CACHE)).removePosition(this.field_145850_b, this.func_174877_v());
                this.networkRegistered = false;
                this.markForUpdate();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        this.setupGatewaySphere();
        this.playGatewayParticles();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupGatewaySphere() {
        if (!this.hasMultiblock() || !this.doesSeeSky()) {
            if (this.clientGatewaySphereEffect != null) {
                ((EntityVisualFX)this.clientGatewaySphereEffect).requestRemoval();
                this.clientGatewaySphereEffect = null;
            }
            return;
        }
        Vector3 at = new Vector3(this).add(0.5, 1.7, 0.5);
        double distance = Vector3.atEntityCorner((Entity)Minecraft.func_71410_x().field_71439_g).distance(at);
        if (this.clientGatewaySphereEffect == null) {
            this.clientGatewaySphereEffect = ((EntityComplexFX)((EntityVisualFX)((FXColorEffectSphere)EffectHelper.of(EffectTemplatesAS.COLOR_SPHERE).spawn(at)).setupSphere(Vector3.RotAxis.Y_AXIS, 6.0f).setRemoveIfInvisible(true).setAlphaFadeDistance(4.0).setAlphaMultiplier(1.0f)).color(VFXColorFunction.BLACK)).refresh(RefreshFunction.tileExistsAnd(this, (te, fx) -> te.doesSeeSky() && te.hasMultiblock()));
        } else if (((EntityVisualFX)this.clientGatewaySphereEffect).isRemoved() && distance < 5.0) {
            EffectHelper.refresh((FXColorEffectSphere)this.clientGatewaySphereEffect, EffectTemplatesAS.COLOR_SPHERE);
        }
        if (distance < 5.5) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        }
        if (distance < 2.5) {
            GatewayUIRenderHandler.getInstance().getOrCreateUI((IWorld)this.func_145831_w(), this.func_174877_v(), at);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playGatewayParticles() {
        Color c;
        Vector3 offset;
        int i;
        if (!this.hasMultiblock() || !this.doesSeeSky()) {
            return;
        }
        Color gatewayColor = ColorUtils.flareColorFromDye(this.getColor().orElse(DyeColor.YELLOW));
        for (i = 0; i < 3; ++i) {
            offset = new Vector3(this).add(-2.0, 0.05, -2.0);
            if (rand.nextBoolean()) {
                offset.add(5 * (rand.nextBoolean() ? 1 : 0), 0.0f, rand.nextFloat() * 5.0f);
            } else {
                offset.add(rand.nextFloat() * 5.0f, 0.0f, 5 * (rand.nextBoolean() ? 1 : 0));
            }
            c = MiscUtils.eitherOf(rand, Color.WHITE, gatewayColor, gatewayColor.brighter());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setGravityStrength(-1.0E-4f)).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.25f + rand.nextFloat() * 0.15f)).setMaxAge(30 + rand.nextInt(30));
        }
        for (i = 0; i < 2; ++i) {
            offset = new Vector3();
            MiscUtils.applyRandomOffset(offset, rand, 3.0f);
            offset.add(new Vector3(this)).add(0.5, 0.0, 0.5).setY((double)this.func_174877_v().func_177956_o() + 0.05);
            c = MiscUtils.eitherOf(rand, Color.WHITE, gatewayColor, gatewayColor.brighter());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setGravityStrength(-4.0E-5f)).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).setMaxAge(15 + rand.nextInt(10));
        }
        if (this.isLocked() && this.getOwner() != null) {
            Color c2;
            Vector3 pos;
            int i2;
            Vector3 center = new Vector3(this).add(0.5, 0.2, 0.5);
            for (i2 = 0; i2 < rand.nextInt(5) + 2; ++i2) {
                pos = MiscUtils.getRandomCirclePosition(center, Vector3.RotAxis.Y_AXIS, 1.7);
                MiscUtils.applyRandomOffset(pos, rand, 0.05f);
                c2 = MiscUtils.eitherOf(rand, Color.WHITE, ColorsAS.EFFECT_BLUE_LIGHT, ColorsAS.EFFECT_BLUE_DARK);
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).color(VFXColorFunction.constant(c2))).setScaleMultiplier(0.25f + rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(15 + rand.nextInt(10));
            }
            for (i2 = 0; i2 < rand.nextInt(3) + 1; ++i2) {
                pos = MiscUtils.getRandomCirclePosition(center, Vector3.RotAxis.Y_AXIS, 1.1).addY(0.3);
                MiscUtils.applyRandomOffset(pos, rand, 0.05f);
                c2 = MiscUtils.eitherOf(rand, Color.WHITE, ColorsAS.EFFECT_BLUE_LIGHT, ColorsAS.EFFECT_BLUE_DARK);
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).color(VFXColorFunction.constant(c2))).setScaleMultiplier(0.25f + rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(15 + rand.nextInt(10));
            }
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean lock() {
        if (this.isLocked() || this.getOwner() == null) {
            return false;
        }
        this.locked = true;
        this.updateAccessInformation();
        return true;
    }

    public boolean unlock() {
        if (!this.isLocked()) {
            return false;
        }
        this.locked = false;
        this.updateAccessInformation();
        return true;
    }

    @Override
    @Nullable
    public PlayerReference getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public PlayerReference setOwner(@Nullable PlayerReference player) {
        PlayerReference prevOwner = this.owner;
        this.owner = player;
        this.updateAccessInformation();
        return prevOwner;
    }

    public boolean canAddAllowedUser(PlayerEntity otherUser) {
        return this.canAddAllowedUser(PlayerReference.of(otherUser));
    }

    public boolean canAddAllowedUser(PlayerReference otherUser) {
        if (this.getOwner() == null) {
            return false;
        }
        if (this.allowedUsers.size() >= OFFSETS_ALLOWED_PREVIEW.length) {
            return false;
        }
        return !this.allowedUsers.containsValue(otherUser);
    }

    public boolean addAllowedUser(PlayerEntity otherUser) {
        return this.addAllowedUser(PlayerReference.of(otherUser));
    }

    public boolean addAllowedUser(PlayerReference otherUser) {
        if (!this.canAddAllowedUser(otherUser)) {
            return false;
        }
        ArrayList<Integer> availableIndices = new ArrayList<Integer>();
        for (int i = 0; i < OFFSETS_ALLOWED_PREVIEW.length; ++i) {
            if (this.allowedUsers.containsKey(i)) continue;
            availableIndices.add(i);
        }
        if (availableIndices.isEmpty()) {
            return false;
        }
        Collections.shuffle(availableIndices);
        this.allowedUsers.put((Integer)MiscUtils.getRandomEntry(availableIndices, rand), otherUser);
        this.updateAccessInformation();
        return true;
    }

    @Nullable
    public PlayerReference removeAllowedUser(UUID otherUser) {
        if (this.allowedUsers.isEmpty()) {
            return null;
        }
        for (Map.Entry<Integer, PlayerReference> entry : this.allowedUsers.entrySet()) {
            if (!entry.getValue().getPlayerUUID().equals(otherUser)) continue;
            this.allowedUsers.remove(entry.getKey());
            this.updateAccessInformation();
            return entry.getValue();
        }
        return null;
    }

    public Map<Integer, PlayerReference> getAllowedUsers() {
        if (this.getOwner() == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.allowedUsers);
    }

    private void updateAccessInformation() {
        ((GatewayCache)DataAS.DOMAIN_AS.getData((IWorld)this.field_145850_b, DataAS.KEY_GATEWAY_CACHE)).updateGatewayNode(this.func_174877_v(), node -> {
            node.setLocked(this.isLocked());
            node.setOwner(this.getOwner());
            node.setAllowedUsers(this.allowedUsers);
        });
        this.markForUpdate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playAccessRevokeEffect(PktPlayEffect pktPlayEffect) {
    }

    public static BlockPos getAllowedUserOffset(int index) {
        return OFFSETS_ALLOWED_PREVIEW[MathHelper.func_76125_a((int)index, (int)0, (int)(OFFSETS_ALLOWED_PREVIEW.length - 1))];
    }

    public void setDisplayText(@Nullable ITextComponent displayText) {
        this.displayText = displayText;
    }

    public void setColor(@Nullable DyeColor color) {
        this.color = color;
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return StructureTypesAS.PTYPE_CELESTIAL_GATEWAY;
    }

    public ITextComponent func_200200_C_() {
        return this.displayText != null ? this.displayText : new TranslationTextComponent("block.astralsorcery.celestial_gateway", new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.displayText != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_200200_C_();
    }

    public Optional<DyeColor> getColor() {
        return Optional.ofNullable(this.color);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.networkRegistered = compound.func_74767_n("networkRegistered");
        this.displayText = compound.func_74764_b("displayText") ? ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("displayText")) : null;
        this.color = compound.func_74764_b("color") ? NBTHelper.readEnum(compound, "color", DyeColor.class) : null;
        this.locked = compound.func_74767_n("locked");
        this.owner = NBTHelper.readOptional(compound, "owningPlayer", PlayerReference::deserialize);
        this.allowedUsers.clear();
        NBTHelper.readList(compound, "allowedUsers", 10, nbt -> {
            CompoundNBT tag = (CompoundNBT)nbt;
            return new Tuple((Object)tag.func_74762_e("index"), (Object)PlayerReference.deserialize(tag.func_74775_l("player")));
        }).forEach(tpl -> this.allowedUsers.put((Integer)tpl.func_76341_a(), (PlayerReference)tpl.func_76340_b()));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("networkRegistered", this.networkRegistered);
        if (this.displayText != null) {
            compound.func_74778_a("displayText", ITextComponent.Serializer.func_150696_a((ITextComponent)this.displayText));
        }
        if (this.color != null) {
            NBTHelper.writeEnum(compound, "color", this.color);
        }
        compound.func_74757_a("locked", this.locked);
        NBTHelper.writeOptional(compound, "owningPlayer", this.owner, (tag, playerRef) -> playerRef.writeToNBT((CompoundNBT)tag));
        NBTHelper.writeList(compound, "allowedUsers", this.allowedUsers.entrySet(), entry -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("index", ((Integer)entry.getKey()).intValue());
            tag.func_218657_a("player", (INBT)((PlayerReference)entry.getValue()).serialize());
            return tag;
        });
    }

    @Override
    public void onBlockLinkCreate(PlayerEntity player, BlockPos other) {
    }

    @Override
    public void onEntityLinkCreate(PlayerEntity player, LivingEntity linked) {
        if (linked instanceof PlayerEntity && this.addAllowedUser((PlayerEntity)linked)) {
            ITextComponent accessGrantedMessage = new TranslationTextComponent("astralsorcery.misc.link.gateway.link", new Object[]{linked.func_145748_c_()}).func_211708_a(TextFormatting.GREEN);
            player.func_145747_a(accessGrantedMessage);
            linked.func_145747_a(accessGrantedMessage);
        }
    }

    @Override
    public boolean tryLinkBlock(PlayerEntity player, BlockPos other) {
        return false;
    }

    @Override
    public boolean tryLinkEntity(PlayerEntity player, LivingEntity other) {
        return other instanceof PlayerEntity && this.canAddAllowedUser((PlayerEntity)other);
    }

    @Override
    public boolean tryUnlink(PlayerEntity player, BlockPos other) {
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return Collections.emptyList();
    }

    @Override
    public boolean onSelect(PlayerEntity player) {
        return false;
    }
}

